/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.seleniumhtmlreport;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import java.io.Serializable;
import java.util.List;
import org.jvnet.hudson.plugins.seleniumhtmlreport.SeleniumHtmlReportPublisher;
import org.jvnet.hudson.plugins.seleniumhtmlreport.TestResult;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumHtmlReportAction
implements Action,
Serializable {
    public final AbstractBuild<?, ?> build;
    private final List<TestResult> results;

    public SeleniumHtmlReportAction(AbstractBuild<?, ?> build, BuildListener listener, List<TestResult> results) {
        this.build = build;
        this.results = results;
    }

    public String getIconFileName() {
        return "/plugin/seleniumhtmlreport/icons/sla-48x48.png";
    }

    public String getDisplayName() {
        return "Selenium Html Report";
    }

    public String getUrlName() {
        return "seleniumhtmlreport";
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.build;
    }

    public List<TestResult> getResults() {
        return this.results;
    }

    public int getSumTestPasses() {
        return this.calculateSumOf(new TestResultValueProvider(){

            public int getValueOf(TestResult result) {
                return result.getNumTestPasses();
            }
        });
    }

    protected int calculateSumOf(TestResultValueProvider values) {
        int sum = 0;
        for (TestResult r : this.results) {
            sum += values.getValueOf(r);
        }
        return sum;
    }

    public int getSumTestFailures() {
        return this.calculateSumOf(new TestResultValueProvider(){

            public int getValueOf(TestResult result) {
                return result.getNumTestFailures();
            }
        });
    }

    public int getSumCommandPasses() {
        return this.calculateSumOf(new TestResultValueProvider(){

            public int getValueOf(TestResult result) {
                return result.getNumCommandPasses();
            }
        });
    }

    public int getSumCommandFailures() {
        return this.calculateSumOf(new TestResultValueProvider(){

            public int getValueOf(TestResult result) {
                return result.getNumCommandFailures();
            }
        });
    }

    public int getSumCommandErrors() {
        return this.calculateSumOf(new TestResultValueProvider(){

            public int getValueOf(TestResult result) {
                return result.getNumCommandErrors();
            }
        });
    }

    public int getSumTestTotal() {
        return this.calculateSumOf(new TestResultValueProvider(){

            public int getValueOf(TestResult result) {
                return result.getNumTestTotal();
            }
        });
    }

    public int getTotalTime() {
        return this.calculateSumOf(new TestResultValueProvider(){

            public int getValueOf(TestResult result) {
                return result.getTotalTime();
            }
        });
    }

    public DirectoryBrowserSupport doDynamic(StaplerRequest req, StaplerResponse rsp) {
        if (this.build != null) {
            return new DirectoryBrowserSupport((ModelObject)this, SeleniumHtmlReportPublisher.getSeleniumReportsDir(this.build), "seleniumhtmlreport", "clipboard.gif", false);
        }
        return null;
    }

    protected static interface TestResultValueProvider {
        public int getValueOf(TestResult var1);
    }
}

