/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.serenitec.SerenitecDescriptor;
import hudson.plugins.serenitec.SerenitecPublisher;
import hudson.plugins.serenitec.SerenitecResultAction;
import hudson.plugins.serenitec.util.ResultAction;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.Cookie;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerenitecProjectAction
implements Action {
    private static final long serialVersionUID = -2512038161663973656L;
    private static final int ONE_YEAR = 31536000;
    private final int height;
    private final String iconUrl;
    private final AbstractProject<?, ?> project;
    private final String resultUrl;
    private final String url;

    public SerenitecProjectAction(AbstractProject<?, ?> project, int height) {
        this(project, SerenitecPublisher.SERENITEC_DESCRIPTOR, height);
    }

    public SerenitecProjectAction(AbstractProject<?, ?> project, SerenitecDescriptor plugin, int height) {
        this.project = project;
        this.height = height;
        this.iconUrl = plugin.getIconUrl();
        this.url = plugin.getPluginName();
        this.resultUrl = plugin.getPluginResultUrlName();
    }

    private void createGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ResultAction action = this.getLastAction();
        if (action == null) {
            response.setStatus(404);
        } else {
            action.doGraph(request, response, this.height);
        }
    }

    public void doFlipTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        boolean useHealthBuilder = false;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.getCookieName())) continue;
                useHealthBuilder = Boolean.parseBoolean(cookie.getValue());
            }
        }
        useHealthBuilder = !useHealthBuilder;
        Cookie cookie = new Cookie(this.getCookieName(), String.valueOf(useHealthBuilder));
        List ancestors = request.getAncestors();
        Ancestor ancestor = (Ancestor)ancestors.get(ancestors.size() - 2);
        cookie.setPath(ancestor.getUrl());
        cookie.setMaxAge(31536000);
        response.addCookie(cookie);
        response.sendRedirect("..");
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2(String.format("../%d/%s", build.getNumber(), this.resultUrl));
        }
    }

    public void doTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        this.createGraph(request, response);
    }

    public void doTrendMap(StaplerRequest request, StaplerResponse response) throws IOException {
        ResultAction action = this.getLastAction();
        if (action == null) {
            response.setStatus(404);
        } else {
            action.doGraphMap(request, response, this.height);
        }
    }

    public String getCookieName() {
        return "Serenitec_displayMode";
    }

    public String getDisplayName() {
        return "Serenitec Project Action name";
    }

    public String getIconFileName() {
        String resultat = this.getLastAction() != null ? this.iconUrl : null;
        return resultat;
    }

    public ResultAction<?> getLastAction() {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        ResultAction resultat = null;
        if (lastBuild != null) {
            resultat = (ResultAction)lastBuild.getAction(SerenitecResultAction.class);
        }
        return resultat;
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this.project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(SerenitecResultAction.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public final AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public final String getUrlName() {
        return this.url;
    }

    public final boolean hasValidResults() {
        ResultAction resultAction;
        AbstractBuild build = this.getLastFinishedBuild();
        Boolean resultat = false;
        if (build != null && (resultAction = (ResultAction)build.getAction(SerenitecResultAction.class)) != null) {
            resultat = resultAction.hasPreviousResultAction();
        }
        return resultat;
    }

    public final boolean isHealthinessEnabled() {
        ResultAction lastAction = this.getLastAction();
        boolean resultat = false;
        if (lastAction != null) {
            resultat = lastAction.getHealthReportBuilder().isEnabled();
        }
        return resultat;
    }
}

