/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.serenitec.SerenitecDescriptor;
import hudson.plugins.serenitec.SerenitecProjectAction;
import hudson.plugins.serenitec.SerenitecResult;
import hudson.plugins.serenitec.SerenitecResultAction;
import hudson.plugins.serenitec.SerenitecResultBuilder;
import hudson.plugins.serenitec.parseur.Gettingxml;
import hudson.plugins.serenitec.parseur.ReportDescription;
import hudson.plugins.serenitec.parseur.ReportEntry;
import hudson.plugins.serenitec.parseur.ReportPointeur;
import hudson.plugins.serenitec.util.HealthAwarePublisher;
import hudson.plugins.serenitec.util.HealthReportBuilder;
import hudson.plugins.serenitec.util.Project;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerenitecPublisher
extends HealthAwarePublisher {
    public static final SerenitecDescriptor SERENITEC_DESCRIPTOR = new SerenitecDescriptor();

    @DataBoundConstructor
    public SerenitecPublisher(String threshold, String healthy, String unHealthy, String height) {
        super(threshold, healthy, unHealthy, height, "SERENITEC");
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED;
    }

    public Descriptor<Publisher> getDescriptor() {
        return SERENITEC_DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new SerenitecProjectAction(project, this.getTrendHeight());
    }

    protected Project perform(AbstractBuild<?, ?> build, PrintStream logger) throws InterruptedException, IOException {
        this.log(logger, "Opening xml event file...");
        String url_fichier_xml = build.getRootDir().getParentFile().getParentFile().toString() + "/workspace/serenitec-report.xml";
        File report_xml = new File(url_fichier_xml);
        Project projet = new Project();
        if (!report_xml.canRead()) {
            this.log(logger, "Unable to read xml event report.");
            build.setResult(Result.FAILURE);
        } else {
            this.log(logger, "Analysing Serenitec report");
            Gettingxml parseur = new Gettingxml(url_fichier_xml);
            try {
                parseur.parse();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList xml = parseur.result();
            projet.addEntries((Collection)xml);
            this.log(logger, "----------------------------------------------------------------");
            this.log(logger, "Number of events : " + projet.getNumberOfEntry());
            this.log(logger, "----------------------------------------------------------------");
            for (ReportEntry entry : projet.getEntries()) {
                this.log(logger, entry.getName());
                this.log(logger, "Severity : " + Integer.toString(entry.getSeverity()));
                for (ReportDescription description : entry.getDescriptions()) {
                    this.log(logger, description.getLanguage() + " : " + description.getDescription() + " (" + description.getHelpreference() + ")");
                }
                for (ReportPointeur pointeur : entry.getPointeurs()) {
                    this.log(logger, pointeur.getFullpath() + " : " + pointeur.getFilename() + " (" + pointeur.getLinenumber() + ") " + pointeur.isIsfixed());
                }
                this.log(logger, "-----------------------------------------------------------------");
            }
            for (ReportEntry entry : projet.getEntriesNotFixed()) {
                this.log(logger, "Not Fixed : " + entry.getName() + " " + entry.getSeverity());
            }
            this.log(logger, "Implementing Serenitec Result Builder.");
            SerenitecResultBuilder test = new SerenitecResultBuilder();
            this.log(logger, "build()");
            this.log(logger, "Nombre d'entry : " + test.build(build, projet).getNumberOfEntry());
            SerenitecResult resultat = new SerenitecResultBuilder().build(build, projet);
            System.out.println("Test ...");
            this.log(logger, "Implementing Health Report Builder.");
            HealthReportBuilder healthReportBuilder = this.createHealthReporter("Messages.Warnings_ResultAction_HealthReportSingleItem()", "Messages.Warnings_ResultAction_HealthReportMultipleItem(\"%d\")");
            this.log(logger, "Adding new Serenitec Result Action into the build");
            build.getActions().add(new SerenitecResultAction(build, healthReportBuilder, resultat));
        }
        System.out.println("Resultat du retour : ");
        System.out.println(projet.getNumberOfEntry());
        return projet;
    }
}

