/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec;

import com.thoughtworks.xstream.XStream;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.serenitec.SerenitecResultAction;
import hudson.plugins.serenitec.parseur.ReportEntry;
import hudson.plugins.serenitec.parseur.ReportPointeur;
import hudson.plugins.serenitec.util.Project;
import hudson.plugins.serenitec.util.ProjectDetails;
import hudson.plugins.serenitec.util.SourceDetail;
import hudson.plugins.serenitec.util.model.EntriesContainer;
import hudson.plugins.serenitec.util.model.EntriesProvider;
import hudson.plugins.serenitec.util.model.EntryStream;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SerenitecResult
implements ModelObject,
Serializable,
EntriesProvider {
    private static final long serialVersionUID = 2768250056765266658L;
    private static final float PERCENTAGE_100_0F = 100.0f;
    private static final XStream XSTREAM = new EntryStream();
    private transient WeakReference<Project> projectSerenitec;
    private final Project save_project;
    private final List<ReportEntry> rules;
    private final List<ReportEntry> entries;
    private final List<ReportEntry> entriesnotfixed;
    private final List<ReportEntry> entriesfixed;
    private final List<ReportEntry> newEntries;
    private final List<ReportPointeur> pointeurs;
    private final int numberOfEntry;
    private final int numberOfEntryBefore;
    private List<ReportEntry> topFiveEntries;
    private final List<ReportEntry> topFiveEntriesBefore;
    private final int numberOfNewEntry;
    private final int numberOfNewEntryBefore;
    private final float numberOfNewEntryPercent;
    private final int numberOfFixedEntry;
    private final int numberOfFixedEntryBefore;
    private final float numberOfFixedEntryPercent;
    private final int numberOfNotFixedEntry;
    private final int numberOfNotFixedEntryBefore;
    private final float numberOfNotFixedEntryPercent;
    private final int delta;
    private final int numberOfSeverityFormatage;
    private final float numberOfSeverityFormatagePercent;
    private final int numberOfSeverityPerformance;
    private final float numberOfSeverityPerformancePercent;
    private final int numberOfSeverityDesign;
    private final float numberOfSeverityDesignPercent;
    private final int numberOfSeverityLowSecurity;
    private final float numberOfSeverityLowSecurityPercent;
    private final int numberOfSeverityHighSecurity;
    private final float numberOfSeverityHighSecurityPercent;
    private final int numberOfSeverityFormatageBefore;
    private final int numberOfSeverityPerformanceBefore;
    private final int numberOfSeverityDesignBefore;
    private final int numberOfSeverityLowSecurityBefore;
    private final int numberOfSeverityHighSecurityBefore;
    private final int numberOfPointeurs;
    private final float numberMoyenneOfPointeursPerEntry;
    private final List<String> errors;
    private final AbstractBuild<?, ?> owner;
    private final int numberOfModules;
    private final int numberOfPointeursBefore;
    private int numberOfRules;
    private int numberOfRulesBefore;

    private static float doPercentage(float _n1, float _n2) {
        return _n1 * 100.0f / _n2;
    }

    public SerenitecResult(AbstractBuild<?, ?> build, Project project) {
        this(build, project, new Project());
    }

    public SerenitecResult(AbstractBuild<?, ?> build, Project project, Project previousProject) {
        this.owner = build;
        this.errors = new ArrayList();
        this.save_project = project;
        this.rules = project.getContainer().getRules();
        this.numberOfRules = this.rules.size();
        this.entries = project.getContainer().getEntries();
        this.numberOfEntry = project.getContainer().getNumberOfEntry();
        this.entriesnotfixed = project.getContainer().getEntriesNotFixed();
        this.numberOfNotFixedEntry = this.entriesnotfixed.size();
        this.numberOfNotFixedEntryPercent = SerenitecResult.doPercentage((float)this.numberOfNotFixedEntry, (float)this.numberOfEntry);
        this.entriesfixed = project.getContainer().getEntriesFixed();
        this.numberOfFixedEntry = this.entriesfixed.size();
        this.numberOfFixedEntryPercent = SerenitecResult.doPercentage((float)this.numberOfFixedEntry, (float)this.numberOfEntry);
        this.topFiveEntries = project.getContainer().getTopFiveEntries();
        this.newEntries = new ArrayList();
        for (ReportEntry entry : this.rules) {
            if (previousProject == project || !previousProject.getContainer().getEntries().contains(entry.getName())) continue;
            this.newEntries.add(entry);
        }
        this.numberOfNewEntry = this.newEntries.size();
        this.numberOfNewEntryPercent = SerenitecResult.doPercentage((float)this.numberOfNewEntry, (float)this.numberOfEntry);
        this.pointeurs = project.getContainer().getPointeurs();
        this.numberOfPointeurs = this.pointeurs.size();
        this.numberMoyenneOfPointeursPerEntry = this.numberOfPointeurs / this.numberOfEntry;
        this.numberOfSeverityFormatage = project.getContainer().getEntriesBySeverity().containsKey(1) ? project.getContainer().getNumberOfSeverityFormatage() : 0;
        this.numberOfSeverityPerformance = project.getContainer().getEntriesBySeverity().containsKey(2) ? project.getContainer().getNumberOfSeverityPerformance() : 0;
        this.numberOfSeverityDesign = project.getContainer().getEntriesBySeverity().containsKey(3) ? project.getContainer().getNumberOfSeverityDesign() : 0;
        this.numberOfSeverityLowSecurity = project.getContainer().getEntriesBySeverity().containsKey(4) ? project.getContainer().getNumberOfSeverityLowSecurity() : 0;
        this.numberOfSeverityHighSecurity = project.getContainer().getEntriesBySeverity().containsKey(5) ? project.getContainer().getNumberOfSeverityHighSecurity() : 0;
        this.numberOfSeverityFormatagePercent = SerenitecResult.doPercentage((float)this.numberOfSeverityFormatage, (float)this.numberOfEntry);
        this.numberOfSeverityPerformancePercent = SerenitecResult.doPercentage((float)this.numberOfSeverityPerformance, (float)this.numberOfEntry);
        this.numberOfSeverityDesignPercent = SerenitecResult.doPercentage((float)this.numberOfSeverityDesign, (float)this.numberOfEntry);
        this.numberOfSeverityLowSecurityPercent = SerenitecResult.doPercentage((float)this.numberOfSeverityLowSecurity, (float)this.numberOfEntry);
        this.numberOfSeverityHighSecurityPercent = SerenitecResult.doPercentage((float)this.numberOfSeverityHighSecurity, (float)this.numberOfEntry);
        if (previousProject.hasAnnotations()) {
            System.out.println("Il y a une build pr\u00e9c\u00e9dente donc on r\u00e9cup\u00e8re ses valeurs");
            this.numberOfRulesBefore = previousProject.getContainer().getRules().size();
            System.out.println("test de numberOfRulesBefore");
            this.numberOfPointeursBefore = previousProject.getContainer().getPointeurs().size();
            System.out.println("numberOfPointeursBefore");
            this.numberOfEntryBefore = previousProject.getContainer().getNumberOfEntry();
            this.numberOfNewEntryBefore = 0;
            this.numberOfNotFixedEntryBefore = previousProject.getContainer().getEntriesNotFixed().size();
            System.out.println("numberOfNotFixedEntryBefore");
            this.numberOfFixedEntryBefore = previousProject.getContainer().getEntriesFixed().size();
            System.out.println("numberOfFixedEntryBefore");
            this.topFiveEntriesBefore = previousProject.getContainer().getTopFiveEntries();
            System.out.println("topFiveEntriesBefore");
            this.numberOfSeverityFormatageBefore = previousProject.getContainer().getNumberOfSeverityFormatage();
            System.out.println("numberOfSeverityFormatageBefore");
            this.numberOfSeverityPerformanceBefore = previousProject.getContainer().getNumberOfSeverityPerformance();
            System.out.println("numberOfSeverityPerformanceBefore");
            this.numberOfSeverityDesignBefore = previousProject.getContainer().getNumberOfSeverityDesign();
            System.out.println("numberOfSeverityDesignBefore");
            this.numberOfSeverityLowSecurityBefore = previousProject.getContainer().getNumberOfSeverityLowSecurity();
            System.out.println("numberOfSeverityLowSecurityBefore");
            this.numberOfSeverityHighSecurityBefore = previousProject.getContainer().getNumberOfSeverityHighSecurity();
            System.out.println("numberOfSeverityHighSecurityBefore");
        } else {
            System.out.println("pas de build precedente donc on positionne avec la valeur par d\u00e9fault : 0");
            this.numberOfRulesBefore = 0;
            this.numberOfPointeursBefore = 0;
            this.numberOfEntryBefore = 0;
            this.numberOfNewEntryBefore = 0;
            this.numberOfNotFixedEntryBefore = 0;
            this.numberOfFixedEntryBefore = 0;
            this.topFiveEntriesBefore = new ArrayList();
            this.numberOfSeverityFormatageBefore = 0;
            this.numberOfSeverityPerformanceBefore = 0;
            this.numberOfSeverityDesignBefore = 0;
            this.numberOfSeverityLowSecurityBefore = 0;
            this.numberOfSeverityHighSecurityBefore = 0;
        }
        System.out.println("----------------------------------------------------");
        System.out.println("Nombre de rules dans le r\u00e9f\u00e9rentiel : " + this.numberOfRules);
        System.out.println("Nombre d'entry : " + this.numberOfEntry);
        System.out.println("Nombre de pointeurs : " + this.numberOfPointeurs);
        System.out.println("Nombre de fixed entry : " + this.numberOfFixedEntry);
        System.out.println("Nombre de not fixed entry : " + this.numberOfNotFixedEntry);
        System.out.println("numberOfSeverityFormatage  : " + this.numberOfSeverityFormatage);
        System.out.println("numberOfSeverityPerformance : " + this.numberOfSeverityPerformance);
        System.out.println("numberOfSeverityDesign : " + this.numberOfSeverityDesign);
        System.out.println("numberOfSeverityLowSecurity : " + this.numberOfSeverityLowSecurity);
        System.out.println("numberOfSeverityHighSecurity : " + this.numberOfSeverityHighSecurity);
        System.out.println("----------------------------------------------------");
        this.delta = this.numberOfEntry - this.numberOfEntryBefore;
        this.numberOfModules = project.getModules().size();
        System.out.println("End of Serenitec Result");
    }

    public EntriesContainer getContainer() {
        return this.getProject();
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getOwner().getRootDir(), "compiler-warnings.xml"));
    }

    public int getDelta() {
        return this.delta;
    }

    public String getDetails() {
        String message = "Voisi le petit r\u00e9sum\u00e9 enfin surtout le d\u00e9tail.. balbalbalbalblablablabla.";
        return "Voisi le petit r\u00e9sum\u00e9 enfin surtout le d\u00e9tail.. balbalbalbalblablablabla.";
    }

    public String getDisplayName() {
        return "Serenitec results";
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        ProjectDetails resultat = null;
        if (link.startsWith("module.")) {
            System.out.println("Analyse du module :  " + StringUtils.substringAfter((String)link, (String)"module."));
        } else if (link.startsWith("testedRules")) {
            resultat = new ProjectDetails(this.getOwner(), "testedRules", this.rules);
        } else if (link.startsWith("errors")) {
            resultat = new ProjectDetails(this.getOwner(), "errors", this.entries);
        } else if (link.startsWith("newErrors")) {
            resultat = new ProjectDetails(this.getOwner(), "newErrors", this.newEntries);
        } else if (link.startsWith("fixedErrors")) {
            resultat = new ProjectDetails(this.getOwner(), "fixedErrors", this.entriesfixed);
        } else if (link.startsWith("unfixedErrors")) {
            resultat = new ProjectDetails(this.getOwner(), "unfixedErrors", this.entriesnotfixed);
        }
        if (link.startsWith("patterns")) {
            resultat = new ProjectDetails(this.getOwner(), "patterns", this.pointeurs);
        } else if (link.startsWith("source.")) {
            System.out.println(StringUtils.substringAfter((String)link, (String)"source."));
            System.out.println("*********************************************************");
            System.out.println(this.save_project.getContainer().getPointeur(Integer.parseInt(StringUtils.substringAfter((String)link, (String)"source."))));
            System.out.println("*********************************************************");
            resultat = new SourceDetail(this.getOwner(), "C:\\developpement-local\\JarClassLoader.java");
        }
        return resultat;
    }

    public final int getNumberOfRules() {
        return this.numberOfRules;
    }

    public int getNumberOfRulesBefore() {
        return this.numberOfRulesBefore;
    }

    public List<ReportEntry> getEntries() {
        return this.rules;
    }

    public List<ReportEntry> getEntriesFixed() {
        return this.entriesfixed;
    }

    public List<ReportEntry> getEntriesNotFixed() {
        return this.entriesnotfixed;
    }

    public int getMaxSeverityDiscovered() {
        int resultat = 0;
        if (this.getNumberOfSeverityHighSecurity() > 0) {
            resultat = 5;
        } else if (this.getNumberOfSeverityLowSecurity() > 0) {
            resultat = 4;
        } else if (this.getNumberOfSeverityDesign() > 0) {
            resultat = 3;
        } else if (this.getNumberOfSeverityPerformance() > 0) {
            resultat = 2;
        } else if (this.getNumberOfSeverityFormatage() > 0) {
            resultat = 1;
        }
        return resultat;
    }

    public List<ReportEntry> getActiveEntry() {
        return this.entries;
    }

    public List<ReportEntry> getNewEntries() {
        return this.newEntries;
    }

    public float getNumberMoyenneOfPointeursPerEntry() {
        return this.numberMoyenneOfPointeursPerEntry;
    }

    public int getNumberOfEntry() {
        return this.numberOfEntry;
    }

    public int getNumberOfEntrybefore() {
        return this.numberOfEntryBefore;
    }

    public int getNumberOfFixedEntry() {
        return this.numberOfFixedEntry;
    }

    public int getNumberOfFixedEntryBefore() {
        return this.numberOfFixedEntryBefore;
    }

    public int getNumberOfFixedEntryPercent() {
        return (int)this.numberOfFixedEntryPercent;
    }

    public int getNumberOfModules() {
        return this.numberOfModules;
    }

    public int getNumberOfNewEntry() {
        return this.numberOfNewEntry;
    }

    public int getNumberOfNewEntryBefore() {
        return this.numberOfNewEntryBefore;
    }

    public int getNumberOfNewEntryPercent() {
        return (int)this.numberOfNewEntryPercent;
    }

    public int getNumberOfNotFixedEntry() {
        return this.numberOfNotFixedEntry;
    }

    public int getNumberOfNotFixedEntryBefore() {
        return this.numberOfNotFixedEntryBefore;
    }

    public int getNumberOfNotFixedEntryPercent() {
        return (int)this.numberOfNotFixedEntryPercent;
    }

    public int getNumberOfPointeurs() {
        return this.numberOfPointeurs;
    }

    public int getNumberOfPointeursBefore() {
        return this.numberOfPointeursBefore;
    }

    public int getNumberOfSeverityDesign() {
        return this.numberOfSeverityDesign;
    }

    public int getNumberOfSeverityDesignBefore() {
        return this.numberOfSeverityDesignBefore;
    }

    public int getNumberOfSeverityDesignPercent() {
        return (int)this.numberOfSeverityDesignPercent;
    }

    public int getNumberOfSeverityFormatage() {
        return this.numberOfSeverityFormatage;
    }

    public int getNumberOfSeverityFormatageBefore() {
        return this.numberOfSeverityFormatageBefore;
    }

    public int getNumberOfSeverityFormatagePercent() {
        return (int)this.numberOfSeverityFormatagePercent;
    }

    public int getNumberOfSeverityHighSecurity() {
        return this.numberOfSeverityHighSecurity;
    }

    public int getNumberOfSeverityHighSecurityBefore() {
        return this.numberOfSeverityHighSecurityBefore;
    }

    public int getNumberOfSeverityHighSecurityPercent() {
        return (int)this.numberOfSeverityHighSecurityPercent;
    }

    public int getNumberOfSeverityLowSecurity() {
        return this.numberOfSeverityLowSecurity;
    }

    public int getNumberOfSeverityLowSecurityBefore() {
        return this.numberOfSeverityLowSecurityBefore;
    }

    public int getNumberOfSeverityLowSecurityPercent() {
        return (int)this.numberOfSeverityLowSecurityPercent;
    }

    public int getNumberOfSeverityPerformance() {
        return this.numberOfSeverityPerformance;
    }

    public int getNumberOfSeverityPerformanceBefore() {
        return this.numberOfSeverityPerformanceBefore;
    }

    public int getNumberOfSeverityPerformancePercent() {
        return (int)this.numberOfSeverityPerformancePercent;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public int getPreviousNumberOfWarnings(String packageName) {
        Project previousResult = this.getPreviousResult();
        int resultat = 0;
        if (previousResult != null) {
            resultat = previousResult.getPackage(packageName).getNumberOfEntry();
        }
        return resultat;
    }

    public Project getPreviousResult() {
        SerenitecResultAction action = (SerenitecResultAction)this.getOwner().getAction(SerenitecResultAction.class);
        Project resultat = null;
        if (action.hasPreviousResultAction()) {
            resultat = ((SerenitecResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return resultat;
    }

    public Project getProject() {
        Project result;
        if (this.projectSerenitec == null) {
            this.loadResult();
        }
        if ((result = (Project)this.projectSerenitec.get()) == null) {
            this.loadResult();
        }
        return (Project)this.projectSerenitec.get();
    }

    public Project getProjectSerenitec() {
        return (Project)this.projectSerenitec.get();
    }

    public List<ReportEntry> getTopFiveEntries() {
        return this.topFiveEntries;
    }

    public List<ReportEntry> getTopFiveEntriesBefore() {
        return this.topFiveEntriesBefore;
    }

    public boolean hasEntry() {
        return this.rules.size() > 0;
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public boolean hasPreviousResult() {
        return ((SerenitecResultAction)this.getOwner().getAction(SerenitecResultAction.class)).hasPreviousResultAction();
    }

    public final boolean isCurrent() {
        return ((AbstractBuild)this.owner.getProject().getLastBuild()).number == this.owner.number;
    }

    private void loadPreviousResult() {
    }

    private void loadResult() {
    }

    public List<ReportEntry> getRules() {
        return this.rules;
    }

    static {
        XSTREAM.alias("Entry", ReportEntry.class);
    }
}

