/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util;

import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.plugins.serenitec.SerenitecDescriptor;
import hudson.plugins.serenitec.util.HealthReportBuilder;
import hudson.plugins.serenitec.util.ResultAction;
import hudson.plugins.serenitec.util.ToolTipProvider;
import hudson.plugins.serenitec.util.model.EntriesProvider;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultAction<T extends EntriesProvider>
implements StaplerProxy,
HealthReportingAction,
ToolTipProvider,
ResultAction<T> {
    private static final long serialVersionUID = -7201451538713818948L;
    private static final int WIDTH = 500;
    private final AbstractBuild<?, ?> owner;
    private HealthReportBuilder healthReportBuilder;
    private T result;

    public AbstractResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder) {
        this.owner = owner;
        this.healthReportBuilder = healthReportBuilder;
    }

    public AbstractResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder, T result) {
        this(owner, healthReportBuilder);
        this.result = result;
    }

    protected CategoryDataset buildDataSet(boolean useHealthBuilder) {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractResultAction action = this; action != null; action = action.getPreviousBuild()) {
            EntriesProvider current = action.getResult();
            if (current == null) continue;
            ArrayList<Integer> series = new ArrayList<Integer>();
            System.out.println("getNumberOfSeverityFormatage = " + current.getNumberOfSeverityFormatage());
            series.add(current.getNumberOfSeverityFormatage());
            System.out.println("getNumberOfSeverityPerformance = " + current.getNumberOfSeverityPerformance());
            series.add(current.getNumberOfSeverityPerformance());
            System.out.println("getNumberOfSeverityDesign = " + current.getNumberOfSeverityDesign());
            series.add(current.getNumberOfSeverityDesign());
            System.out.println("getNumberOfSeverityLowSecurity = " + current.getNumberOfSeverityLowSecurity());
            series.add(current.getNumberOfSeverityLowSecurity());
            System.out.println("getNumberOfSeverityHighSecurity = " + current.getNumberOfSeverityHighSecurity());
            series.add(current.getNumberOfSeverityHighSecurity());
            int level = 0;
            for (Integer integer : series) {
                builder.add((Number)integer, (Comparable)Integer.valueOf(level), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.getOwner()));
                ++level;
            }
        }
        return builder.build();
    }

    protected CategoryDataset buildDetailsDataSet(boolean useHealthBuilder, String param) {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractResultAction action = this; action != null; action = action.getPreviousBuild()) {
            EntriesProvider current = action.getResult();
            if (current == null) continue;
            ArrayList<Integer> series = new ArrayList<Integer>();
            if (param.equals("testedRules")) {
                series.add(current.getNumberOfRules());
            } else if (param.equals("errors")) {
                series.add(current.getNumberOfEntry());
            } else if (param.equals("newErrors")) {
                series.add(current.getNumberOfEntry());
            } else if (param.equals("fixedErrors")) {
                series.add(current.getNumberOfFixedEntry());
            } else if (param.equals("unfixedErrors")) {
                series.add(current.getNumberOfNotFixedEntry());
            } else if (param.equals("patterns")) {
                series.add(current.getNumberOfPointeurs());
            }
            int level = 0;
            for (Integer integer : series) {
                builder.add((Number)integer, (Comparable)Integer.valueOf(level), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.getOwner()));
                ++level;
            }
        }
        return builder.build();
    }

    private JFreeChart createChart(StaplerRequest request, StaplerResponse response) {
        System.out.println("---createChart------");
        String parameter = request.getParameter("useHealthBuilder");
        boolean useHealthBuilder = Boolean.valueOf(StringUtils.defaultIfEmpty((String)parameter, (String)"true"));
        return this.getHealthReportBuilder().createGraph(useHealthBuilder, this.getDescriptor().getPluginResultUrlName(), this.buildDataSet(useHealthBuilder), (ToolTipProvider)this);
    }

    private JFreeChart createDetailsChart(StaplerRequest request, StaplerResponse response, String param) {
        System.out.println("---createRepositoryChart------");
        return this.getHealthReportBuilder().createGraph(false, this.getDescriptor().getPluginResultUrlName(), this.buildDetailsDataSet(false, param), (ToolTipProvider)this);
    }

    public final void doGraph(StaplerRequest request, StaplerResponse response, int height) throws IOException {
        System.out.println("---doGraph------");
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request, response), (int)500, (int)height);
    }

    public void doDetailsGraph(StaplerRequest request, StaplerResponse response, String param) throws IOException {
        System.out.println("---doRepositoryGraph------");
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createDetailsChart(request, response, param), (int)850, (int)200);
    }

    public final void doGraphMap(StaplerRequest request, StaplerResponse response, int height) throws IOException {
        ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request, response), (int)500, (int)height);
    }

    public final HealthReport getBuildHealth() {
        return this.healthReportBuilder.computeHealth(this.getResult().getNumberOfPointeurs() - this.getPreviousBuild().getResult().getNumberOfPointeurs());
    }

    protected abstract SerenitecDescriptor getDescriptor();

    public final HealthReportBuilder getHealthReportBuilder() {
        if (this.healthReportBuilder == null) {
            this.healthReportBuilder = new HealthReportBuilder();
        }
        return this.healthReportBuilder;
    }

    public String getIconFileName() {
        String resultat = null;
        if (this.getResult().getNumberOfEntry() > 0) {
            resultat = this.getDescriptor().getIconUrl();
        }
        return resultat;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    protected AbstractResultAction<T> getPreviousBuild() {
        AbstractResultAction action;
        AbstractBuild build = this.getOwner();
        do {
            if ((build = (AbstractBuild)build.getPreviousBuild()) != null) continue;
            return null;
        } while ((action = (AbstractResultAction)build.getAction(this.getClass())) == null);
        return action;
    }

    public final T getResult() {
        return (T)this.result;
    }

    public final Object getTarget() {
        return this.getResult();
    }

    public String getUrlName() {
        return this.getDescriptor().getPluginResultUrlName();
    }

    public boolean hasPreviousResultAction() {
        return this.getPreviousBuild() != null;
    }

    public final void setResult(T result) {
        this.result = result;
    }
}

