/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util;

import hudson.plugins.serenitec.util.Diff;
import java.util.Hashtable;

public class Diff {
    private int equiv_max = 1;
    public boolean heuristic = false;
    public boolean no_discards = false;
    private int[] xvec;
    private int[] yvec;
    private int[] fdiag;
    private int[] bdiag;
    private int fdiagoff;
    private int bdiagoff;
    private final file_data[] filevec = new file_data[2];
    private int cost;
    private boolean inhibit = false;
    public static final ScriptBuilder forwardScript = new ForwardScript();
    public static final ScriptBuilder reverseScript = new ReverseScript();

    public Diff(Object[] a, Object[] b) {
        Hashtable h = new Hashtable(a.length + b.length);
        this.filevec[0] = new file_data(this, a, h);
        this.filevec[1] = new file_data(this, b, h);
    }

    private int diag(int xoff, int xlim, int yoff, int ylim) {
        int[] fd = this.fdiag;
        int[] bd = this.bdiag;
        int[] xv = this.xvec;
        int[] yv = this.yvec;
        int dmin = xoff - ylim;
        int dmax = xlim - yoff;
        int fmid = xoff - yoff;
        int bmid = xlim - ylim;
        int fmin = fmid;
        int fmax = fmid;
        int bmin = bmid;
        int bmax = bmid;
        boolean odd = (fmid - bmid & 1) != 0;
        fd[this.fdiagoff + fmid] = xoff;
        bd[this.bdiagoff + bmid] = xlim;
        int c = 1;
        while (true) {
            int y;
            int oldx;
            int x;
            int thi;
            int tlo;
            int d;
            boolean big_snake = false;
            if (fmin > dmin) {
                fd[this.fdiagoff + --fmin - 1] = -1;
            } else {
                ++fmin;
            }
            if (fmax < dmax) {
                fd[this.fdiagoff + ++fmax + 1] = -1;
            } else {
                --fmax;
            }
            for (d = fmax; d >= fmin; d -= 2) {
                tlo = fd[this.fdiagoff + d - 1];
                thi = fd[this.fdiagoff + d + 1];
                x = tlo >= thi ? tlo + 1 : thi;
                oldx = x;
                for (y = x - d; x < xlim && y < ylim && xv[x] == yv[y]; ++x, ++y) {
                }
                if (x - oldx > 20) {
                    big_snake = true;
                }
                fd[this.fdiagoff + d] = x;
                if (!odd || bmin > d || d > bmax || bd[this.bdiagoff + d] > fd[this.fdiagoff + d]) continue;
                this.cost = 2 * c - 1;
                return d;
            }
            if (bmin > dmin) {
                bd[this.bdiagoff + --bmin - 1] = Integer.MAX_VALUE;
            } else {
                ++bmin;
            }
            if (bmax < dmax) {
                bd[this.bdiagoff + ++bmax + 1] = Integer.MAX_VALUE;
            } else {
                --bmax;
            }
            for (d = bmax; d >= bmin; d -= 2) {
                tlo = bd[this.bdiagoff + d - 1];
                thi = bd[this.bdiagoff + d + 1];
                x = tlo < thi ? tlo : thi - 1;
                oldx = x;
                for (y = x - d; x > xoff && y > yoff && xv[x - 1] == yv[y - 1]; --x, --y) {
                }
                if (oldx - x > 20) {
                    big_snake = true;
                }
                bd[this.bdiagoff + d] = x;
                if (odd || fmin > d || d > fmax || bd[this.bdiagoff + d] > fd[this.fdiagoff + d]) continue;
                this.cost = 2 * c;
                return d;
            }
            if (c > 200 && big_snake && this.heuristic) {
                int k;
                int x2;
                int dd;
                int best = 0;
                int bestpos = -1;
                for (d = fmax; d >= fmin; d -= 2) {
                    dd = d - fmid;
                    if ((fd[this.fdiagoff + d] - xoff) * 2 - dd <= 12 * (c + (dd > 0 ? dd : -dd)) || fd[this.fdiagoff + d] * 2 - dd <= best || fd[this.fdiagoff + d] - xoff <= 20 || fd[this.fdiagoff + d] - d - yoff <= 20) continue;
                    x2 = fd[this.fdiagoff + d];
                    for (k = 1; k <= 20 && this.xvec[x2 - k] == this.yvec[x2 - d - k]; ++k) {
                    }
                    if (k != 21) continue;
                    best = fd[this.fdiagoff + d] * 2 - dd;
                    bestpos = d;
                }
                if (best > 0) {
                    this.cost = 2 * c - 1;
                    return bestpos;
                }
                best = 0;
                for (d = bmax; d >= bmin; d -= 2) {
                    dd = d - bmid;
                    if ((xlim - bd[this.bdiagoff + d]) * 2 + dd <= 12 * (c + (dd > 0 ? dd : -dd)) || (xlim - bd[this.bdiagoff + d]) * 2 + dd <= best || xlim - bd[this.bdiagoff + d] <= 20 || ylim - (bd[this.bdiagoff + d] - d) <= 20) continue;
                    x2 = bd[this.bdiagoff + d];
                    for (k = 0; k < 20 && this.xvec[x2 + k] == this.yvec[x2 - d + k]; ++k) {
                    }
                    if (k != 20) continue;
                    best = (xlim - bd[this.bdiagoff + d]) * 2 + dd;
                    bestpos = d;
                }
                if (best > 0) {
                    this.cost = 2 * c - 1;
                    return bestpos;
                }
            }
            ++c;
        }
    }

    private void compareseq(int xoff, int xlim, int yoff, int ylim) {
        while (xoff < xlim && yoff < ylim && this.xvec[xoff] == this.yvec[yoff]) {
            ++xoff;
            ++yoff;
        }
        while (xlim > xoff && ylim > yoff && this.xvec[xlim - 1] == this.yvec[ylim - 1]) {
            --xlim;
            --ylim;
        }
        if (xoff == xlim) {
            while (yoff < ylim) {
                this.filevec[1].changed_flag[1 + this.filevec[1].realindexes[yoff++]] = true;
            }
        } else if (yoff == ylim) {
            while (xoff < xlim) {
                this.filevec[0].changed_flag[1 + this.filevec[0].realindexes[xoff++]] = true;
            }
        } else {
            int d = this.diag(xoff, xlim, yoff, ylim);
            int c = this.cost;
            int f = this.fdiag[this.fdiagoff + d];
            int b = this.bdiag[this.bdiagoff + d];
            if (c == 1) {
                throw new IllegalArgumentException("Empty subsequence");
            }
            this.compareseq(xoff, b, yoff, b - d);
            this.compareseq(b, xlim, b - d, ylim);
        }
    }

    private void discard_confusing_lines() {
        this.filevec[0].discard_confusing_lines(this.filevec[1]);
        this.filevec[1].discard_confusing_lines(this.filevec[0]);
    }

    private void shift_boundaries() {
        if (this.inhibit) {
            return;
        }
        this.filevec[0].shift_boundaries(this.filevec[1]);
        this.filevec[1].shift_boundaries(this.filevec[0]);
    }

    public final change diff_2(boolean reverse) {
        return this.diff(reverse ? reverseScript : forwardScript);
    }

    public change diff(ScriptBuilder bld) {
        this.discard_confusing_lines();
        this.xvec = this.filevec[0].undiscarded;
        this.yvec = this.filevec[1].undiscarded;
        int diags = this.filevec[0].nondiscarded_lines + this.filevec[1].nondiscarded_lines + 3;
        this.fdiag = new int[diags];
        this.fdiagoff = this.filevec[1].nondiscarded_lines + 1;
        this.bdiag = new int[diags];
        this.bdiagoff = this.filevec[1].nondiscarded_lines + 1;
        this.compareseq(0, this.filevec[0].nondiscarded_lines, 0, this.filevec[1].nondiscarded_lines);
        this.fdiag = null;
        this.bdiag = null;
        this.shift_boundaries();
        return bld.build_script(this.filevec[0].changed_flag, this.filevec[0].buffered_lines, this.filevec[1].changed_flag, this.filevec[1].buffered_lines);
    }

    static /* synthetic */ int access$000(Diff x0) {
        return x0.equiv_max;
    }

    static /* synthetic */ int access$008(Diff x0) {
        return x0.equiv_max++;
    }
}

