/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util;

import hudson.Util;
import hudson.model.HealthReport;
import hudson.plugins.serenitec.util.ChartBuilder;
import hudson.plugins.serenitec.util.PrioritiesAreaRenderer;
import hudson.plugins.serenitec.util.ResultAreaRenderer;
import hudson.plugins.serenitec.util.ToolTipProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthReportBuilder
implements Serializable {
    private static final long serialVersionUID = 5191317904662711835L;
    private int healthy;
    private int unHealthy;
    private boolean isHealthEnabled;
    private String reportName;
    private String itemName;
    private boolean isThresholdEnabled;
    private int severityMax;
    private final String reportSingleCount;
    private final String reportMultipleCount;

    public HealthReportBuilder() {
        this(false, 0, false, 0, 0, "1 item", "%d items");
    }

    public HealthReportBuilder(boolean isFailureThresholdEnabled, int severityMax, boolean isHealthyReportEnabled, int healthy, int unHealthy, String reportSingleCount, String reportMultipleCount) {
        this.reportSingleCount = reportSingleCount;
        this.reportMultipleCount = reportMultipleCount;
        this.severityMax = severityMax;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.isThresholdEnabled = isFailureThresholdEnabled;
        this.isHealthEnabled = isHealthyReportEnabled;
    }

    public HealthReport computeHealth(int counter) {
        System.out.println("Execution de computeHealth");
        if (this.isHealthEnabled) {
            System.out.println("ifHealthEnabled == true");
            System.out.println("Healthy =" + this.healthy);
            System.out.println("unHealthy =" + this.unHealthy);
            System.out.println("counter =" + counter);
            int percentage = counter < this.healthy ? 100 : (counter > this.unHealthy ? 0 : 100 - (counter - this.healthy) * 100 / (this.unHealthy - this.healthy));
            String description = this.isLocalizedRelease() ? (counter == 1 ? this.reportSingleCount : String.format(this.reportMultipleCount, counter)) : this.reportName + ": " + Util.combine((long)counter, (String)this.itemName) + " found.";
            return new HealthReport(percentage, description);
        }
        return null;
    }

    public final int getHealthy() {
        return this.healthy;
    }

    public final String getItemName() {
        return this.itemName;
    }

    public final String getReportName() {
        return this.reportName;
    }

    public int getThreshold() {
        return this.severityMax;
    }

    public final int getUnHealthy() {
        return this.unHealthy;
    }

    public boolean isEnabled() {
        return this.isHealthEnabled || this.isThresholdEnabled;
    }

    public boolean isFailureThresholdEnabled() {
        return this.isThresholdEnabled;
    }

    public final boolean isHealthyReportEnabled() {
        return this.isHealthEnabled;
    }

    List<Integer> createSeries(int numberOfEntry) {
        ArrayList<Integer> series = new ArrayList<Integer>(3);
        int remainder = numberOfEntry;
        if (this.isHealthEnabled) {
            series.add(Math.min(remainder, this.healthy));
            int range = this.unHealthy - this.healthy;
            if ((remainder -= this.healthy) > 0) {
                series.add(Math.min(remainder, range));
            } else {
                series.add(0);
            }
            if ((remainder -= range) > 0) {
                series.add(remainder);
            } else {
                series.add(0);
            }
        } else if (this.isThresholdEnabled) {
            series.add(Math.min(remainder, this.severityMax));
            if ((remainder -= this.severityMax) > 0) {
                series.add(remainder);
            } else {
                series.add(0);
            }
        }
        return series;
    }

    private boolean isLocalizedRelease() {
        return this.itemName == null;
    }

    public void setFailureThresholdEnabled(boolean isFailureThresholdEnabled) {
        this.isThresholdEnabled = isFailureThresholdEnabled;
    }

    public final void setHealthy(int healthy) {
        this.healthy = healthy;
    }

    public final void setHealthyReportEnabled(boolean isHealthyReportEnabled) {
        this.isHealthEnabled = isHealthyReportEnabled;
    }

    public final void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public final void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public void setThreshold(int threshold) {
        this.severityMax = threshold;
    }

    public final void setUnHealthy(int unHealthy) {
        this.unHealthy = unHealthy;
    }

    public JFreeChart createGraph(boolean useHealthBuilder, String url, CategoryDataset dataset, ToolTipProvider toolTipProvider) {
        Object renderer = useHealthBuilder && this.isEnabled() ? new ResultAreaRenderer(url, toolTipProvider) : new PrioritiesAreaRenderer(url, toolTipProvider);
        return ChartBuilder.createChart((CategoryDataset)dataset, (StackedAreaRenderer)renderer, (int)this.getThreshold(), (this.isHealthyReportEnabled() || !this.isFailureThresholdEnabled() || !useHealthBuilder ? 1 : 0) != 0);
    }

    public JFreeChart createGraphLine(boolean useHealthBuilder, String url, CategoryDataset dataset, ToolTipProvider toolTipProvider) {
        return ChartBuilder.createChart((CategoryDataset)dataset);
    }
}

