/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.serenitec.util.Diff;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SourceDetail
implements ModelObject {
    private final String _fileBefore;
    private final String _fileAfter;
    private final AbstractBuild<?, ?> _owner;
    private String _sourceCode;

    public SourceDetail(AbstractBuild<?, ?> owner, String filepath) {
        this._fileAfter = filepath;
        this._fileBefore = this.getBeforeFile(filepath);
        this._owner = owner;
    }

    private String getBeforeFile(String filepath) {
        return filepath + ".bis";
    }

    public String getSourceCode() {
        this.execute();
        return this._sourceCode;
    }

    private void execute() {
        try {
            Object[] a = SourceDetail.file2string((String)this._fileBefore);
            Object[] b = SourceDetail.file2string((String)this._fileAfter);
            Diff diff = new Diff(a, b);
            Diff.change next = diff.diff_2(false);
            next = diff.diff_2(false);
            StringBuilder stb = new StringBuilder();
            stb.append("<table class=\"diff\" cellpadding=\"0\" cellspacing=\"0\" >");
            stb.append("<tr>");
            stb.append("<td class=\"ligne_entete\">&nbsp;</td>");
            stb.append("<td class=\"original_entete\">Original File<br /><small>" + this._fileBefore + "</small></td>");
            stb.append("<td class=\"ligne_entete\">&nbsp;</td>");
            stb.append("<td class=\"refactored_entete\">Refactored File<br /><small>" + this._fileAfter + "</small></td>");
            stb.append("</tr>");
            int max = a.length;
            if (max < b.length) {
                max = b.length;
            }
            int numeroLigneAvant = 0;
            int numeroLigneApres = 0;
            while (numeroLigneAvant < a.length || numeroLigneApres < b.length) {
                stb.append("<tr>");
                Object ligneAvant = numeroLigneAvant >= a.length || a[numeroLigneAvant] == null ? "" : a[numeroLigneAvant];
                Object ligneApres = numeroLigneApres >= b.length || b[numeroLigneApres] == null ? "" : b[numeroLigneApres];
                if (next != null && next.line0 == numeroLigneAvant) {
                    int i;
                    if (next.inserted > 0 && next.deleted == 0) {
                        for (i = 0; i < next.inserted; ++i) {
                            stb.append("<tr>");
                            stb.append("<td class=\"ligne_normal\">" + numeroLigneAvant + "</td>");
                            stb.append("<td class=\"original_added\">&nbsp;</td>");
                            stb.append("<td class=\"ligne_added\">" + numeroLigneApres + "</td>");
                            stb.append("<td class=\"refactored_added\">" + (String)ligneApres + "</td>");
                            stb.append("</tr>");
                            ligneApres = ++numeroLigneApres >= b.length || b[numeroLigneApres] == null ? "" : b[numeroLigneApres];
                        }
                    }
                    if (next.deleted > 0 && next.inserted == 0) {
                        for (i = 0; i < next.deleted; ++i) {
                            stb.append("<tr>");
                            stb.append("<td class=\"ligne_deleted\">" + numeroLigneAvant + "</td>");
                            stb.append("<td class=\"original_deleted\">" + (String)ligneAvant + "</td>");
                            stb.append("<td class=\"ligne_normal\">" + numeroLigneApres + "</td>");
                            stb.append("<td class=\"refactored_deleted\">&nbsp;</td>");
                            stb.append("</tr>");
                            ligneAvant = ++numeroLigneAvant >= a.length || a[numeroLigneAvant] == null ? "" : a[numeroLigneAvant];
                        }
                    }
                    if (next.deleted > 0 && next.inserted > 0) {
                        int max_temp = 0;
                        int min_temp = 0;
                        max_temp = next.deleted;
                        min_temp = next.inserted;
                        if (max_temp < next.inserted) {
                            max_temp = next.inserted;
                            min_temp = next.deleted;
                        }
                        for (int i2 = 1; i2 <= max_temp; ++i2) {
                            if (i2 > min_temp) {
                                if (next.deleted > next.inserted) {
                                    stb.append("<tr>");
                                    stb.append("<td class=\"ligne_deleted\">" + numeroLigneAvant + "</td>");
                                    stb.append("<td class=\"original_deleted\">" + (String)ligneAvant + "</td>");
                                    stb.append("<td class=\"ligne_normal\">" + numeroLigneApres + "</td>");
                                    stb.append("<td class=\"refactored_deleted\">&nbsp;</td>");
                                    stb.append("</tr>");
                                    if (++numeroLigneAvant >= a.length || a[numeroLigneAvant] == null) {
                                        ligneAvant = "";
                                        continue;
                                    }
                                    ligneAvant = a[numeroLigneAvant];
                                    continue;
                                }
                                stb.append("<tr>");
                                stb.append("<td class=\"ligne_normal\">" + numeroLigneAvant + "</td>");
                                stb.append("<td class=\"original_added\">&nbsp;</td>");
                                stb.append("<td class=\"ligne_added\">" + numeroLigneApres + "</td>");
                                stb.append("<td class=\"refactored_added\">" + (String)ligneApres + "</td>");
                                stb.append("</tr>");
                                if (++numeroLigneApres >= b.length || b[numeroLigneApres] == null) {
                                    ligneApres = "";
                                    continue;
                                }
                                ligneApres = b[numeroLigneApres];
                                continue;
                            }
                            stb.append("<tr>");
                            stb.append("<td class=\"ligne_modified\">" + numeroLigneAvant + "</td>");
                            stb.append("<td class=\"original_modified\">" + (String)ligneAvant + "</td>");
                            stb.append("<td class=\"ligne_modified\">" + numeroLigneApres + "</td>");
                            stb.append("<td class=\"refactored_modified\">" + (String)ligneApres + "</td>");
                            stb.append("</tr>");
                            ++numeroLigneApres;
                            ligneAvant = ++numeroLigneAvant >= a.length || a[numeroLigneAvant] == null ? "" : a[numeroLigneAvant];
                            ligneApres = numeroLigneApres >= b.length || b[numeroLigneApres] == null ? "" : b[numeroLigneApres];
                        }
                    }
                    next = next.link;
                    continue;
                }
                stb.append("<tr>");
                stb.append("<td class=\"ligne_normal\">" + numeroLigneAvant + "</td>");
                stb.append("<td class=\"original_normal\">" + (String)ligneAvant + "</td>");
                stb.append("<td class=\"ligne_normal\">" + numeroLigneApres + "</td>");
                stb.append("<td class=\"refactored_normal\">" + (String)ligneApres + "</td>");
                stb.append("</tr>");
                ++numeroLigneAvant;
                ++numeroLigneApres;
            }
            stb.append("</table>");
            this._sourceCode = stb.toString();
        }
        catch (IOException ex) {
            Logger.getLogger(SourceDetail.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static String[] file2string(String file) throws IOException {
        String line;
        BufferedReader rdr = new BufferedReader(new FileReader(file));
        Vector<String> s = new Vector<String>();
        while ((line = rdr.readLine()) != null) {
            s.addElement(line);
        }
        Object[] a = new String[s.size()];
        s.copyInto(a);
        return a;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this._owner;
    }

    public String getDisplayName() {
        return "getDisplayName : SourceDetail";
    }
}

