/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util.model;

import hudson.plugins.serenitec.parseur.ReportEntry;
import hudson.plugins.serenitec.parseur.ReportPointeur;
import hudson.plugins.serenitec.util.model.EntriesContainer;
import hudson.plugins.serenitec.util.model.EntriesProvider;
import hudson.plugins.serenitec.util.model.MavenModule;
import hudson.plugins.serenitec.util.model.Package;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntriesContainer
implements EntriesProvider,
Serializable {
    private static final long serialVersionUID = 855696821788264261L;
    private final List<ReportEntry> rules = new ArrayList();
    private final List<ReportEntry> entries = new ArrayList();
    private transient Map<Integer, ArrayList<ReportEntry>> entriesBySeverity;
    private transient Map<String, ArrayList<ReportEntry>> entriesByName;
    private transient List<ReportEntry> entriesNotFixed;
    private transient List<ReportEntry> entriesFixed;
    private transient List<ReportEntry> entriesOrderByNumberOfPointeurs;
    private transient List<ReportEntry> topFiveEntries;
    private transient List<ReportPointeur> pointeurs;
    private transient Map<String, Package> packagesByName;
    private transient Map<String, MavenModule> modulesByName;
    private String name;
    private Hierarchy hierarchy;

    public EntriesContainer(Hierarchy hierarchy) {
        this("", hierarchy);
    }

    protected EntriesContainer(String name, Hierarchy hierarchy) {
        this.initialize();
        this.name = name;
        this.hierarchy = hierarchy;
    }

    private void addCategory(ReportEntry annotation) {
    }

    public final void addEntries(Collection<? extends ReportEntry> newentry) {
        for (ReportEntry reportEntry : newentry) {
            this.addEntry(reportEntry);
        }
        this.initialize();
    }

    public final void addEntries(ReportEntry[] newAnnotations) {
        this.addEntries(Arrays.asList(newAnnotations));
    }

    public final void addEntry(ReportEntry entry) {
        this.rules.add(entry);
        if (entry.isActive()) {
            this.entries.add(entry);
        }
        this.updateMappings(entry);
    }

    private void addFile(ReportEntry annotation) {
    }

    private void addModule(ReportEntry annotation) {
    }

    private void addPackage(ReportEntry annotation) {
    }

    private void addType(ReportEntry annotation) {
    }

    public boolean containsModule(String moduleName) {
        return this.modulesByName.containsKey(moduleName);
    }

    public boolean containsPackage(String packageName) {
        return this.packagesByName.containsKey(packageName);
    }

    public final int getAnnotationBound() {
        int maximum = 0;
        for (EntriesContainer subContainer : this.getChildren()) {
            maximum = Math.max(maximum, subContainer.getNumberOfEntry());
        }
        return maximum;
    }

    public final Collection<ReportEntry> getAnnotations() {
        return Collections.unmodifiableCollection(this.rules);
    }

    protected abstract Collection<? extends EntriesContainer> getChildren();

    public EntriesContainer getContainer() {
        return this;
    }

    public ReportPointeur getPointeur(int key) {
        for (ReportPointeur pointeur : this.pointeurs) {
            if (pointeur.getKey() != key) continue;
            return pointeur;
        }
        return null;
    }

    public final List<ReportEntry> getRules() {
        return this.rules;
    }

    public final List<ReportEntry> getEntries() {
        return this.entries;
    }

    public final Map<String, ArrayList<ReportEntry>> getEntriesByName() {
        return this.entriesByName;
    }

    public final Map<Integer, ArrayList<ReportEntry>> getEntriesBySeverity() {
        return this.entriesBySeverity;
    }

    public final List<ReportEntry> getEntriesFixed() {
        return this.entriesFixed;
    }

    public List<ReportEntry> getEntriesNotFixed() {
        return this.entriesNotFixed;
    }

    public int getMaxSeverityDiscovered() {
        int resultat = 0;
        if (this.getNumberOfSeverityHighSecurity() > 0) {
            resultat = 5;
        } else if (this.getNumberOfSeverityLowSecurity() > 0) {
            resultat = 4;
        } else if (this.getNumberOfSeverityDesign() > 0) {
            resultat = 3;
        } else if (this.getNumberOfSeverityPerformance() > 0) {
            resultat = 2;
        } else if (this.getNumberOfSeverityFormatage() > 0) {
            resultat = 1;
        }
        return resultat;
    }

    public MavenModule getModule(String moduleName) {
        if (this.modulesByName.containsKey(moduleName)) {
            return (MavenModule)this.modulesByName.get(moduleName);
        }
        throw new NoSuchElementException("Module not found: " + moduleName);
    }

    public Collection<MavenModule> getModules() {
        return Collections.unmodifiableCollection(this.modulesByName.values());
    }

    public final Map<String, MavenModule> getModulesByName() {
        return this.modulesByName;
    }

    public final String getName() {
        return this.name;
    }

    public int getNumberOfRules() {
        return this.rules.size();
    }

    public int getNumberOfEntry() {
        return this.entries.size();
    }

    public int getNumberOfFixedEntry() {
        return this.entriesFixed.size();
    }

    public int getNumberOfNotFixedEntry() {
        return this.entriesNotFixed.size();
    }

    public int getNumberOfPointeurs() {
        return this.pointeurs.size();
    }

    public int getNumberOfSeverityDesign() {
        if (this.entriesBySeverity.containsKey(3)) {
            return ((ArrayList)this.entriesBySeverity.get(3)).size();
        }
        return 0;
    }

    public int getNumberOfSeverityFormatage() {
        if (this.entriesBySeverity.containsKey(1)) {
            return ((ArrayList)this.entriesBySeverity.get(1)).size();
        }
        return 0;
    }

    public int getNumberOfSeverityHighSecurity() {
        if (this.entriesBySeverity.containsKey(5)) {
            return ((ArrayList)this.entriesBySeverity.get(5)).size();
        }
        return 0;
    }

    public int getNumberOfSeverityLowSecurity() {
        if (this.entriesBySeverity.containsKey(4)) {
            return ((ArrayList)this.entriesBySeverity.get(4)).size();
        }
        return 0;
    }

    public int getNumberOfSeverityPerformance() {
        if (this.entriesBySeverity.containsKey(2)) {
            return ((ArrayList)this.entriesBySeverity.get(2)).size();
        }
        return 0;
    }

    public Package getPackage(String packageName) {
        if (this.packagesByName.containsKey(packageName)) {
            return (Package)this.packagesByName.get(packageName);
        }
        throw new NoSuchElementException("Package not found: " + packageName);
    }

    public final String getPackageCategoryName() {
        return "Entete message header getpackageCategoryName";
    }

    public Collection<Package> getPackages() {
        return Collections.unmodifiableCollection(this.packagesByName.values());
    }

    public final List<ReportPointeur> getPointeurs() {
        return this.pointeurs;
    }

    public String getToolTip() {
        StringBuilder message = new StringBuilder();
        return StringUtils.removeEnd((String)"repartition selon les priorit\u00e9s des entry", (String)" - ");
    }

    public final List<ReportEntry> getTopFiveEntries() {
        return this.topFiveEntries;
    }

    public final boolean hasAnnotations() {
        return !this.entries.isEmpty();
    }

    private void initialize() {
        this.entriesBySeverity = new Hashtable();
        this.entriesByName = new Hashtable();
        this.entriesNotFixed = new ArrayList();
        this.entriesFixed = new ArrayList();
        this.topFiveEntries = new ArrayList();
        this.entriesOrderByNumberOfPointeurs = new ArrayList();
        this.pointeurs = new ArrayList();
        for (ReportEntry entry : this.entries) {
            ArrayList temp;
            if (this.entriesBySeverity.containsKey(entry.getSeverity())) {
                temp = (ArrayList)this.entriesBySeverity.get(entry.getSeverity());
                temp.add(entry);
                this.entriesBySeverity.put(entry.getSeverity(), temp);
            } else {
                temp = new ArrayList();
                temp.add(entry);
                this.entriesBySeverity.put(entry.getSeverity(), temp);
            }
            if (this.entriesByName.containsKey(entry.getName())) {
                temp = (ArrayList)this.entriesByName.get(entry.getName());
                temp.add(entry);
                this.entriesByName.put(entry.getName(), temp);
            }
            boolean etat_pointeur = true;
            for (ReportPointeur pointeur : entry.getPointeurs()) {
                if (!pointeur.isIsfixed()) {
                    etat_pointeur = false;
                }
                this.pointeurs.add(pointeur);
            }
            if (etat_pointeur) {
                this.entriesFixed.add(entry);
                continue;
            }
            this.entriesNotFixed.add(entry);
        }
        this.entriesOrderByNumberOfPointeurs = this.rules;
        Collections.sort(this.entriesOrderByNumberOfPointeurs, Collections.reverseOrder());
        for (int i = 0; i < 5 && i < this.entriesOrderByNumberOfPointeurs.size(); ++i) {
            this.topFiveEntries.add(this.entriesOrderByNumberOfPointeurs.get(i));
        }
        this.packagesByName = new HashMap();
        this.modulesByName = new HashMap();
    }

    public final boolean IsFixed() {
        return this.getNumberOfNotFixedEntry() == 0;
    }

    private Object readResolve() {
        this.rebuildMappings();
        return this;
    }

    protected void rebuildMappings() {
        this.initialize();
        for (ReportEntry entry : this.getEntries()) {
            this.updateMappings(entry);
        }
    }

    protected void setHierarchy(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public final void setName(String name) {
        this.name = name;
    }

    private void updateMappings(ReportEntry annotation) {
    }
}

