/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.serenitec.SerenitecDescriptor;
import hudson.plugins.serenitec.SerenitecProjectAction;
import hudson.plugins.serenitec.SerenitecResult;
import hudson.plugins.serenitec.SerenitecResultAction;
import hudson.plugins.serenitec.SerenitecResultBuilder;
import hudson.plugins.serenitec.parseur.Gettingxml;
import hudson.plugins.serenitec.util.HealthAwarePublisher;
import hudson.plugins.serenitec.util.HealthReportBuilder;
import hudson.plugins.serenitec.util.Project;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerenitecPublisher
extends HealthAwarePublisher {
    public static final SerenitecDescriptor SERENITEC_DESCRIPTOR = new SerenitecDescriptor();

    @DataBoundConstructor
    public SerenitecPublisher(String threshold, String healthy, String unHealthy, String height) {
        super(threshold, healthy, unHealthy, height, "Serenitec Hudson Plugin");
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED;
    }

    public Descriptor<Publisher> getDescriptor() {
        return SERENITEC_DESCRIPTOR;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new SerenitecProjectAction(project, this.getTrendHeight());
    }

    protected Project perform(AbstractBuild<?, ?> build, PrintStream logger) throws InterruptedException, IOException {
        Project projet = new Project();
        String uri_report = build.getRootDir().getParentFile().getParentFile().getAbsolutePath() + "\\" + "serenitec-report.xml";
        this.log(logger, "Scanning for the report in " + uri_report);
        File report = new File(uri_report);
        if (!report.exists() || !report.canRead()) {
            this.log(logger, "Error : Unable to read xml event report.");
            build.setResult(Result.FAILURE);
        } else {
            this.log(logger, "Opening report file and parsing results :");
            Gettingxml parseur = new Gettingxml(report.getAbsolutePath());
            try {
                parseur.parse();
            }
            catch (Exception e) {
                this.log(logger, "Error on parsing results : " + e.getLocalizedMessage());
                build.setResult(Result.FAILURE);
            }
            ArrayList xml = parseur.result();
            projet.addEntries((Collection)xml, build);
            this.log(logger, "-Repository-------------------------------------");
            this.log(logger, " Number of Rules : " + projet.getNumberOfRules());
            this.log(logger, " Number of Errors : " + projet.getNumberOfEntry());
            this.log(logger, " Number of Patterns : " + projet.getNumberOfPointeurs());
            this.log(logger, " Number of Fixed errors : " + projet.getNumberOfFixedEntry());
            this.log(logger, " Number of Unfixed errors : " + projet.getNumberOfNotFixedEntry());
            this.log(logger, "------------------------------------------------");
            SerenitecResult resultat = new SerenitecResultBuilder().build(build, projet);
            HealthReportBuilder healthReportBuilder = this.createHealthReporter("Serenitec Reports : 1 open task found.", "Serenitec Reports : {\"%d\"} open tasks found.");
            this.log(logger, "Adding new Serenitec Result Action into the build");
            build.getActions().add(new SerenitecResultAction(build, healthReportBuilder, resultat));
        }
        return projet;
    }
}

