/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec;

import com.thoughtworks.xstream.XStream;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.serenitec.SerenitecResultAction;
import hudson.plugins.serenitec.parseur.ReportEntry;
import hudson.plugins.serenitec.parseur.ReportPointeur;
import hudson.plugins.serenitec.util.ErrorDetails;
import hudson.plugins.serenitec.util.Project;
import hudson.plugins.serenitec.util.ProjectDetails;
import hudson.plugins.serenitec.util.ResultAction;
import hudson.plugins.serenitec.util.SeverityDetails;
import hudson.plugins.serenitec.util.SourceDetail;
import hudson.plugins.serenitec.util.model.EntriesContainer;
import hudson.plugins.serenitec.util.model.EntriesProvider;
import hudson.plugins.serenitec.util.model.EntryStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SerenitecResult
implements ModelObject,
Serializable,
EntriesProvider {
    private static final long serialVersionUID = 2768250056765266658L;
    private static final float PERCENTAGE_100_0F = 100.0f;
    private static final XStream XSTREAM = new EntryStream();
    private transient WeakReference<Project> projectSerenitec;
    private Project save_project;
    private List<ReportEntry> rules;
    private List<ReportEntry> entries;
    private List<ReportEntry> entriesnotfixed;
    private List<ReportEntry> entriesfixed;
    private List<ReportEntry> newEntries;
    private List<ReportPointeur> pointeurs;
    private List<String> modifiedFiles;
    private int numberOfEntry;
    private int numberOfEntryBefore;
    private List<ReportEntry> topFiveEntries;
    private List<ReportEntry> topFiveEntriesBefore;
    private int numberOfNewEntry;
    private int numberOfNewEntryBefore;
    private float numberOfNewEntryPercent;
    private int numberOfFixedEntry;
    private int numberOfFixedEntryBefore;
    private float numberOfFixedEntryPercent;
    private int numberOfNotFixedEntry;
    private int numberOfNotFixedEntryBefore;
    private float numberOfNotFixedEntryPercent;
    private int delta;
    private int numberOfSeverityFormatage;
    private int numberOfSeverityFormatagePatterns;
    private float numberOfSeverityFormatagePercent;
    private int numberOfSeverityPerformance;
    private int numberOfSeverityPerformancePatterns;
    private float numberOfSeverityPerformancePercent;
    private int numberOfSeverityDesign;
    private int numberOfSeverityDesignPatterns;
    private float numberOfSeverityDesignPercent;
    private int numberOfSeverityLowSecurity;
    private int numberOfSeverityLowSecurityPatterns;
    private float numberOfSeverityLowSecurityPercent;
    private int numberOfSeverityHighSecurity;
    private int numberOfSeverityHighSecurityPatterns;
    private float numberOfSeverityHighSecurityPercent;
    private int numberOfSeverityFormatageBefore;
    private int numberOfSeverityPerformanceBefore;
    private int numberOfSeverityDesignBefore;
    private int numberOfSeverityLowSecurityBefore;
    private int numberOfSeverityHighSecurityBefore;
    private int numberOfPointeurs;
    private float numberMoyenneOfPointeursPerEntry;
    private List<String> errors;
    private AbstractBuild<?, ?> owner;
    private int numberOfModules;
    private int numberOfPointeursBefore;
    private int numberOfRules;
    private int numberOfRulesBefore;

    public static float doPercentage(float _n1, float _n2) {
        return _n1 * 100.0f / _n2;
    }

    public SerenitecResult(AbstractBuild<?, ?> build, Project project) {
        this(build, project, (EntriesContainer)new Project());
    }

    public SerenitecResult(AbstractBuild<?, ?> build, Project project, SerenitecResult previous) {
        Project previousProject = previous.getProject();
        System.out.println("Lancement de initialize() par SerenitecResult(final AbstractBuild<?, ?> build, final Project project, final SerenitecResult previous)");
        this.initialize(build, project, (EntriesContainer)previousProject);
        System.out.println("Fin du lancementy");
    }

    public SerenitecResult(AbstractBuild<?, ?> build, Project project, EntriesContainer previousProject) {
        System.out.println("Executing SerenitecResult.SerenitecResult(final AbstractBuild<?, ?> build, final Project project, final EntriesContainer previousProject)");
        this.initialize(build, project, previousProject);
    }

    public void initialize(AbstractBuild<?, ?> build, Project project, EntriesContainer previousProject) {
        System.out.println("Executing SerenitecResult.initialize()");
        this.owner = build;
        this.errors = new ArrayList();
        this.save_project = project;
        this.rules = project.getContainer().getRules();
        this.numberOfRules = this.rules.size();
        this.entries = project.getContainer().getEntries();
        this.numberOfEntry = project.getContainer().getNumberOfEntry();
        this.modifiedFiles = project.getContainer().getModifiedFiles();
        this.entriesnotfixed = project.getContainer().getEntriesNotFixed();
        this.numberOfNotFixedEntry = this.entriesnotfixed.size();
        this.numberOfNotFixedEntryPercent = SerenitecResult.doPercentage((float)this.numberOfNotFixedEntry, (float)this.numberOfEntry);
        this.entriesfixed = project.getContainer().getEntriesFixed();
        this.numberOfFixedEntry = this.entriesfixed.size();
        this.numberOfFixedEntryPercent = SerenitecResult.doPercentage((float)this.numberOfFixedEntry, (float)this.numberOfEntry);
        this.topFiveEntries = project.getContainer().getTopFiveEntries();
        this.pointeurs = project.getContainer().getPointeurs();
        this.numberOfPointeurs = project.getContainer().getNumberOfPointeurs();
        this.numberMoyenneOfPointeursPerEntry = this.numberOfPointeurs / this.numberOfEntry;
        if (project.getContainer().getEntriesBySeverity().containsKey(1)) {
            this.numberOfSeverityFormatage = project.getContainer().getNumberOfSeverityFormatage();
            this.numberOfSeverityFormatagePatterns = project.getContainer().getNumberOfSeverityFormatagePatterns();
        } else {
            this.numberOfSeverityFormatage = 0;
            this.numberOfSeverityFormatagePatterns = 0;
        }
        if (project.getContainer().getEntriesBySeverity().containsKey(2)) {
            this.numberOfSeverityPerformance = project.getContainer().getNumberOfSeverityPerformance();
            this.numberOfSeverityPerformancePatterns = project.getContainer().getNumberOfSeverityPerformancePatterns();
        } else {
            this.numberOfSeverityPerformance = 0;
            this.numberOfSeverityPerformancePatterns = 0;
        }
        if (project.getContainer().getEntriesBySeverity().containsKey(3)) {
            this.numberOfSeverityDesign = project.getContainer().getNumberOfSeverityDesign();
            this.numberOfSeverityDesignPatterns = project.getContainer().getNumberOfSeverityDesignPatterns();
        } else {
            this.numberOfSeverityDesign = 0;
            this.numberOfSeverityDesignPatterns = 0;
        }
        if (project.getContainer().getEntriesBySeverity().containsKey(4)) {
            this.numberOfSeverityLowSecurity = project.getContainer().getNumberOfSeverityLowSecurity();
            this.numberOfSeverityLowSecurityPatterns = project.getContainer().getNumberOfSeverityLowSecurityPatterns();
        } else {
            this.numberOfSeverityLowSecurity = 0;
            this.numberOfSeverityLowSecurityPatterns = 0;
        }
        if (project.getContainer().getEntriesBySeverity().containsKey(5)) {
            this.numberOfSeverityHighSecurity = project.getContainer().getNumberOfSeverityHighSecurity();
            this.numberOfSeverityHighSecurityPatterns = project.getContainer().getNumberOfSeverityHighSecurityPatterns();
        } else {
            this.numberOfSeverityHighSecurity = 0;
            this.numberOfSeverityHighSecurityPatterns = 0;
        }
        this.numberOfSeverityFormatagePercent = SerenitecResult.doPercentage((float)this.numberOfSeverityFormatage, (float)this.numberOfEntry);
        this.numberOfSeverityPerformancePercent = SerenitecResult.doPercentage((float)this.numberOfSeverityPerformance, (float)this.numberOfEntry);
        this.numberOfSeverityDesignPercent = SerenitecResult.doPercentage((float)this.numberOfSeverityDesign, (float)this.numberOfEntry);
        this.numberOfSeverityLowSecurityPercent = SerenitecResult.doPercentage((float)this.numberOfSeverityLowSecurity, (float)this.numberOfEntry);
        this.numberOfSeverityHighSecurityPercent = SerenitecResult.doPercentage((float)this.numberOfSeverityHighSecurity, (float)this.numberOfEntry);
        System.out.println("if (previousProject.hasAnnotations())");
        if (previousProject.hasAnnotations()) {
            this.numberOfRulesBefore = previousProject.getContainer().getRules().size();
            this.numberOfPointeursBefore = previousProject.getContainer().getNumberOfPointeurs();
            this.numberOfEntryBefore = previousProject.getContainer().getNumberOfEntry();
            this.numberOfNotFixedEntryBefore = previousProject.getContainer().getEntriesNotFixed().size();
            this.numberOfFixedEntryBefore = previousProject.getContainer().getEntriesFixed().size();
            this.topFiveEntriesBefore = previousProject.getContainer().getTopFiveEntries();
            this.numberOfSeverityFormatageBefore = previousProject.getContainer().getNumberOfSeverityFormatage();
            this.numberOfSeverityPerformanceBefore = previousProject.getContainer().getNumberOfSeverityPerformance();
            this.numberOfSeverityDesignBefore = previousProject.getContainer().getNumberOfSeverityDesign();
            this.numberOfSeverityLowSecurityBefore = previousProject.getContainer().getNumberOfSeverityLowSecurity();
            this.numberOfSeverityHighSecurityBefore = previousProject.getContainer().getNumberOfSeverityHighSecurity();
            this.newEntries = new ArrayList();
            for (ReportEntry entry : this.rules) {
                if (previousProject == project || !previousProject.getContainer().getEntries().contains(entry.getName())) continue;
                this.newEntries.add(entry);
            }
            this.numberOfNewEntry = this.newEntries.size();
            this.numberOfNewEntryPercent = SerenitecResult.doPercentage((float)this.numberOfNewEntry, (float)this.numberOfEntry);
            this.numberOfNewEntryBefore = 0;
        } else {
            System.out.println("pas de build precedente donc on positionne avec la valeur par d\u00e9fault : 0");
            this.numberOfRulesBefore = 0;
            this.numberOfPointeursBefore = 0;
            this.numberOfEntryBefore = 0;
            this.numberOfNewEntryBefore = 0;
            this.numberOfNewEntryPercent = 0.0f;
            this.numberOfNewEntry = 0;
            this.newEntries = new ArrayList();
            this.numberOfNotFixedEntryBefore = 0;
            this.numberOfFixedEntryBefore = 0;
            this.topFiveEntriesBefore = new ArrayList();
            this.numberOfSeverityFormatageBefore = 0;
            this.numberOfSeverityPerformanceBefore = 0;
            this.numberOfSeverityDesignBefore = 0;
            this.numberOfSeverityLowSecurityBefore = 0;
            this.numberOfSeverityHighSecurityBefore = 0;
        }
        System.out.println("----------------------------------------------------");
        System.out.println("Nombre de rules dans le r\u00e9f\u00e9rentiel : " + this.numberOfRules);
        System.out.println("Nombre d'entry : " + this.numberOfEntry);
        System.out.println("Nombre de pointeurs : " + this.numberOfPointeurs);
        System.out.println("Nombre de pointeurs before : " + this.numberOfPointeursBefore);
        System.out.println("Nombre de fixed entry : " + this.numberOfFixedEntry);
        System.out.println("Nombre de not fixed entry : " + this.numberOfNotFixedEntry);
        System.out.println("numberOfSeverityFormatage  : " + this.numberOfSeverityFormatage);
        System.out.println("numberOfSeverityPerformance : " + this.numberOfSeverityPerformance);
        System.out.println("numberOfSeverityDesign : " + this.numberOfSeverityDesign);
        System.out.println("numberOfSeverityLowSecurity : " + this.numberOfSeverityLowSecurity);
        System.out.println("numberOfSeverityHighSecurity : " + this.numberOfSeverityHighSecurity);
        System.out.println("----------------------------------------------------");
        this.delta = this.numberOfEntry - this.numberOfEntryBefore;
        this.numberOfModules = project.getModules().size();
        System.out.println("End of SerenitecResult");
    }

    public void doErrorBySeverityTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        this.createGraph(request, response, "errorBySeverityTrend");
    }

    public void doPatternsBySeverityTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        this.createGraph(request, response, "patternsBySeverityTrend");
    }

    public void doTopFiveTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        this.createGraph(request, response, "topFiveTrend");
    }

    private void createGraph(StaplerRequest request, StaplerResponse response, String type) throws IOException {
        ResultAction action = this.getLastAction();
        if (action == null) {
            response.setStatus(404);
        } else {
            action.doPersonalGraph(request, response, 200, type);
        }
    }

    public ResultAction<?> getLastAction() {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        ResultAction resultat = null;
        if (lastBuild != null) {
            resultat = (ResultAction)lastBuild.getAction(SerenitecResultAction.class);
        }
        return resultat;
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = this.owner; lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(SerenitecResultAction.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public List<String> getModifiedFiles() {
        return this.modifiedFiles;
    }

    public EntriesContainer getContainer() {
        return this.getProject();
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getOwner().getRootDir(), "compiler-serenitec.xml"));
    }

    public int getDelta() {
        return this.delta;
    }

    public String getDetails() {
        String message = "Voisi le petit r\u00e9sum\u00e9 enfin surtout le d\u00e9tail.. balbalbalbalblablablabla.";
        return "Voisi le petit r\u00e9sum\u00e9 enfin surtout le d\u00e9tail.. balbalbalbalblablablabla.";
    }

    public String getDisplayName() {
        return "Serenitec results";
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        ProjectDetails resultat = null;
        if (link.startsWith("module.")) {
            System.out.println("Analyse du module :  " + StringUtils.substringAfter((String)link, (String)"module."));
        } else if (link.startsWith("Severity")) {
            System.out.println("Analyse de la severit\u00e9  :  " + StringUtils.substringAfter((String)link, (String)"Severity."));
            resultat = new SeverityDetails(this.getOwner(), this.save_project, Integer.parseInt(StringUtils.substringAfter((String)link, (String)"Severity.")));
        } else if (link.startsWith("Errors")) {
            System.out.println("Analyse d'une erreur :  " + StringUtils.substringAfter((String)link, (String)"Errors."));
            resultat = new ErrorDetails(this.getOwner(), this.save_project, StringUtils.substringAfter((String)link, (String)"Errors."));
        } else if (link.startsWith("testedRules")) {
            resultat = new ProjectDetails(this.getOwner(), "testedRules", this.rules);
        } else if (link.startsWith("errors")) {
            resultat = new ProjectDetails(this.getOwner(), "errors", this.entries);
        } else if (link.startsWith("newErrors")) {
            resultat = new ProjectDetails(this.getOwner(), "newErrors", this.newEntries);
        } else if (link.startsWith("fixedErrors")) {
            resultat = new ProjectDetails(this.getOwner(), "fixedErrors", this.entriesfixed);
        } else if (link.startsWith("unfixedErrors")) {
            resultat = new ProjectDetails(this.getOwner(), "unfixedErrors", this.entriesnotfixed);
        }
        if (link.startsWith("patterns")) {
            resultat = new ProjectDetails(this.getOwner(), "patterns", this.pointeurs);
        } else if (link.startsWith("source.")) {
            System.out.println(StringUtils.substringAfter((String)link, (String)"source."));
            System.out.println("*********************************************************");
            System.out.println(this.save_project.getContainer().getPointeur(Integer.parseInt(StringUtils.substringAfter((String)link, (String)"source."))));
            System.out.println("*********************************************************");
            int key = Integer.parseInt(StringUtils.substringAfter((String)link, (String)"source."));
            ReportPointeur send_pattern = null;
            for (ReportPointeur pattern : this.pointeurs) {
                if (pattern.getKey() != key) continue;
                send_pattern = pattern;
            }
            resultat = new SourceDetail(this.getOwner(), send_pattern);
        }
        return resultat;
    }

    public final int getNumberOfRules() {
        return this.numberOfRules;
    }

    public int getNumberOfRulesBefore() {
        return this.numberOfRulesBefore;
    }

    public List<ReportEntry> getEntries() {
        return this.rules;
    }

    public List<ReportEntry> getEntriesFixed() {
        return this.entriesfixed;
    }

    public List<ReportEntry> getEntriesNotFixed() {
        return this.entriesnotfixed;
    }

    public int getMaxSeverityDiscovered() {
        int resultat = 0;
        if (this.getNumberOfSeverityHighSecurity() > 0) {
            resultat = 5;
        } else if (this.getNumberOfSeverityLowSecurity() > 0) {
            resultat = 4;
        } else if (this.getNumberOfSeverityDesign() > 0) {
            resultat = 3;
        } else if (this.getNumberOfSeverityPerformance() > 0) {
            resultat = 2;
        } else if (this.getNumberOfSeverityFormatage() > 0) {
            resultat = 1;
        }
        return resultat;
    }

    public List<ReportEntry> getActiveEntry() {
        return this.entries;
    }

    public List<ReportEntry> getNewEntries() {
        return this.newEntries;
    }

    public float getNumberMoyenneOfPointeursPerEntry() {
        return this.numberMoyenneOfPointeursPerEntry;
    }

    public int getNumberOfEntry() {
        return this.numberOfEntry;
    }

    public int getNumberOfEntryBefore() {
        return this.numberOfEntryBefore;
    }

    public int getNumberOfFixedEntry() {
        return this.numberOfFixedEntry;
    }

    public int getNumberOfFixedEntryBefore() {
        return this.numberOfFixedEntryBefore;
    }

    public int getNumberOfFixedEntryPercent() {
        return (int)this.numberOfFixedEntryPercent;
    }

    public int getNumberOfModules() {
        return this.numberOfModules;
    }

    public int getNumberOfNewEntry() {
        return this.numberOfNewEntry;
    }

    public int getNumberOfNewEntryBefore() {
        return this.numberOfNewEntryBefore;
    }

    public int getNumberOfNewEntryPercent() {
        return (int)this.numberOfNewEntryPercent;
    }

    public int getNumberOfNotFixedEntry() {
        return this.numberOfNotFixedEntry;
    }

    public int getNumberOfNotFixedEntryBefore() {
        return this.numberOfNotFixedEntryBefore;
    }

    public int getNumberOfNotFixedEntryPercent() {
        return (int)this.numberOfNotFixedEntryPercent;
    }

    public int getNumberOfPointeurs() {
        return this.numberOfPointeurs;
    }

    public int getNumberOfPointeursBefore() {
        return this.numberOfPointeursBefore;
    }

    public int getNumberOfSeverityDesign() {
        return this.numberOfSeverityDesign;
    }

    public int getNumberOfSeverityDesignBefore() {
        return this.numberOfSeverityDesignBefore;
    }

    public int getNumberOfSeverityDesignPercent() {
        return (int)this.numberOfSeverityDesignPercent;
    }

    public int getNumberOfSeverityFormatage() {
        return this.numberOfSeverityFormatage;
    }

    public int getNumberOfSeverityFormatageBefore() {
        return this.numberOfSeverityFormatageBefore;
    }

    public int getNumberOfSeverityFormatagePercent() {
        return (int)this.numberOfSeverityFormatagePercent;
    }

    public int getNumberOfSeverityHighSecurity() {
        return this.numberOfSeverityHighSecurity;
    }

    public int getNumberOfSeverityHighSecurityBefore() {
        return this.numberOfSeverityHighSecurityBefore;
    }

    public int getNumberOfSeverityHighSecurityPercent() {
        return (int)this.numberOfSeverityHighSecurityPercent;
    }

    public int getNumberOfSeverityLowSecurity() {
        return this.numberOfSeverityLowSecurity;
    }

    public int getNumberOfSeverityLowSecurityBefore() {
        return this.numberOfSeverityLowSecurityBefore;
    }

    public int getNumberOfSeverityLowSecurityPercent() {
        return (int)this.numberOfSeverityLowSecurityPercent;
    }

    public int getNumberOfSeverityPerformance() {
        return this.numberOfSeverityPerformance;
    }

    public int getNumberOfSeverityPerformanceBefore() {
        return this.numberOfSeverityPerformanceBefore;
    }

    public int getNumberOfSeverityPerformancePercent() {
        return (int)this.numberOfSeverityPerformancePercent;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public int getPreviousNumberOfWarnings(String packageName) {
        Project previousResult = this.getPreviousResult();
        int resultat = 0;
        if (previousResult != null) {
            resultat = previousResult.getPackage(packageName).getNumberOfEntry();
        }
        return resultat;
    }

    public Project getPreviousResult() {
        SerenitecResultAction action = (SerenitecResultAction)this.getOwner().getAction(SerenitecResultAction.class);
        Project resultat = null;
        if (action.hasPreviousResultAction()) {
            resultat = ((SerenitecResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return resultat;
    }

    public Project getProject() {
        return this.save_project;
    }

    public Project getProjectSerenitec() {
        return (Project)this.projectSerenitec.get();
    }

    public List<ReportEntry> getTopFiveEntries() {
        return this.topFiveEntries;
    }

    public List<ReportEntry> getTopFiveEntriesBefore() {
        return this.topFiveEntriesBefore;
    }

    public boolean hasRules() {
        return this.rules.size() > 0;
    }

    public boolean hasEntries() {
        return this.entries.size() > 0;
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public boolean hasPreviousResult() {
        return ((SerenitecResultAction)this.getOwner().getAction(SerenitecResultAction.class)).hasPreviousResultAction();
    }

    public final boolean isCurrent() {
        return ((AbstractBuild)this.owner.getProject().getLastBuild()).number == this.owner.number;
    }

    private void loadPreviousResult() {
    }

    private void loadResult() {
    }

    public List<ReportEntry> getRules() {
        return this.rules;
    }

    public int getNumberOfSeverityDesignPatterns() {
        return this.numberOfSeverityDesignPatterns;
    }

    public int getNumberOfSeverityFormatagePatterns() {
        return this.numberOfSeverityFormatagePatterns;
    }

    public int getNumberOfSeverityHighSecurityPatterns() {
        return this.numberOfSeverityHighSecurityPatterns;
    }

    public int getNumberOfSeverityLowSecurityPatterns() {
        return this.numberOfSeverityLowSecurityPatterns;
    }

    public int getNumberOfSeverityPerformancePatterns() {
        return this.numberOfSeverityPerformancePatterns;
    }

    static {
        XSTREAM.alias("Entry", ReportEntry.class);
    }
}

