/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.parseur;

import hudson.plugins.serenitec.parseur.ReportDescription;
import hudson.plugins.serenitec.parseur.ReportPointeur;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportEntry
implements Comparable<ReportEntry> {
    String name;
    int severity;
    ArrayList<ReportPointeur> pointeurs = new ArrayList();
    ArrayList<ReportDescription> descriptions = new ArrayList();

    @Override
    public int compareTo(ReportEntry _o) {
        int resultat = 0;
        if (this.getNumberOfPointeurs() < _o.getNumberOfPointeurs()) {
            resultat = -1;
        } else if (this.getNumberOfPointeurs() > _o.getNumberOfPointeurs()) {
            resultat = 1;
        }
        return resultat;
    }

    public boolean equals(ReportEntry _o) {
        boolean etat = false;
        if (this.name.equals(_o.getName())) {
            etat = true;
            for (ReportPointeur pointeur : this.pointeurs) {
                if (_o.getPointeurs().contains(pointeur)) continue;
                etat = false;
            }
        }
        return etat;
    }

    public ArrayList<ReportDescription> getDescriptions() {
        return this.descriptions;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<ReportPointeur> getPointeurs() {
        return this.pointeurs;
    }

    public int getNumberOfPointeurs() {
        return this.pointeurs.size();
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setDescriptions(ArrayList<ReportDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPointeurs(ArrayList<ReportPointeur> pointeurs) {
        this.pointeurs = pointeurs;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public boolean isActive() {
        return this.pointeurs.size() > 0;
    }

    public ReportPointeur getPattern(int key) {
        ReportPointeur resultat = null;
        for (ReportPointeur pattern : this.getPointeurs()) {
            if (pattern.getKey() != key) continue;
            resultat = pattern;
        }
        return resultat;
    }

    public boolean isFixed() {
        boolean resultat = true;
        for (ReportPointeur pattern : this.getPointeurs()) {
            if (pattern.isIsfixed()) continue;
            resultat = false;
        }
        return resultat;
    }
}

