/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.serenitec.SerenitecResultAction;
import hudson.plugins.serenitec.parseur.ReportEntry;
import hudson.plugins.serenitec.util.Project;
import hudson.plugins.serenitec.util.ResultAction;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorDetails
implements ModelObject {
    private final String titre;
    private final String error;
    private final AbstractBuild<?, ?> owner;
    private final Project project;
    private ReportEntry entry;

    public ErrorDetails(AbstractBuild<?, ?> Owner, Project Projet, String error) {
        this.titre = "Error " + error;
        this.owner = Owner;
        this.project = Projet;
        this.error = error;
        this.entry = null;
        for (ReportEntry test_entry : Projet.getEntries()) {
            if (!test_entry.getName().equals(error)) continue;
            this.entry = test_entry;
        }
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public String getDisplayName() {
        return "Error " + this.entry.getName();
    }

    public ReportEntry getEntry() {
        return this.entry;
    }

    public void doRepartitionPie(StaplerRequest request, StaplerResponse response) throws IOException {
        int n1 = this.entry.getNumberOfPointeurs();
        int n2 = this.project.getNumberOfPointeurs();
        this.createGraph(request, response, n1, n2);
    }

    private void createGraph(StaplerRequest request, StaplerResponse response, int n1, int n2) throws IOException {
        ResultAction action = this.getLastAction();
        if (action == null) {
            response.setStatus(404);
        } else {
            action.doRulesRepartitionPie(request, response, 200, n1, n2, this.error);
        }
    }

    public ResultAction<?> getLastAction() {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        ResultAction resultat = null;
        if (lastBuild != null) {
            resultat = (ResultAction)lastBuild.getAction(SerenitecResultAction.class);
        }
        return resultat;
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = this.owner; lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(SerenitecResultAction.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }
}

