/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util;

import hudson.plugins.serenitec.util.ToolTipBuilder;
import hudson.plugins.serenitec.util.ToolTipProvider;
import hudson.util.ChartUtil;
import hudson.util.StackedAreaRenderer2;
import org.jfree.data.category.CategoryDataset;

public class PrioritiesAreaRenderer
extends StackedAreaRenderer2 {
    private static final long serialVersionUID = -4683951507836348304L;
    private final String url;
    private final ToolTipBuilder toolTipBuilder;

    public PrioritiesAreaRenderer(String url, ToolTipProvider toolTipProvider) {
        this.toolTipBuilder = new ToolTipBuilder(toolTipProvider);
        this.url = "/" + url + "/";
    }

    public final String generateURL(CategoryDataset dataset, int row, int column) {
        return this.getLabel((CategoryDataset)dataset, (int)column).build.getNumber() + this.url;
    }

    public final ToolTipBuilder getToolTipBuilder() {
        return this.toolTipBuilder;
    }

    private ChartUtil.NumberOnlyBuildLabel getLabel(CategoryDataset dataset, int column) {
        return (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
    }

    public String generateToolTip(CategoryDataset dataset, int row, int column) {
        StringBuilder tooltip = new StringBuilder();
        tooltip.append(this.getToolTipBuilder().getTooltip(dataset.getValue(row, column).intValue()));
        tooltip.append(" ");
        switch (row) {
            case 1: {
                tooltip.append("Formating");
                break;
            }
            case 2: {
                tooltip.append("Performance");
                break;
            }
            case 3: {
                tooltip.append("Design");
                break;
            }
            case 4: {
                tooltip.append("Low security");
                break;
            }
            default: {
                tooltip.append("High Security");
            }
        }
        return tooltip.toString();
    }
}

