/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ModelObject;
import hudson.plugins.serenitec.SerenitecResultAction;
import hudson.plugins.serenitec.util.AbstractResultAction;
import hudson.plugins.serenitec.util.ResultAction;
import java.io.IOException;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDetails
implements ModelObject {
    private Boolean TestedRules;
    private Boolean Errors;
    private Boolean NewErrors;
    private Boolean FixedErrors;
    private Boolean NotFixedErrors;
    private Boolean Patterns;
    private final String _details;
    private String titre = "";
    private final AbstractBuild<?, ?> _owner;
    private final AbstractProject<?, ?> _project;
    private List<?> Data;
    private boolean isEntry;

    public List<?> getData() {
        return this.Data;
    }

    public void setData(List<?> data) {
        this.Data = data;
    }

    public ProjectDetails(AbstractBuild<?, ?> owner, String details, List<?> data) {
        this._details = details;
        this._owner = owner;
        this._project = owner.getProject();
        this.isEntry = true;
        this.TestedRules = false;
        this.Errors = false;
        this.NewErrors = false;
        this.FixedErrors = false;
        this.NotFixedErrors = false;
        this.Patterns = false;
        this.setDisplayName();
        if (this._details.equals("testedRules")) {
            this.Data = data;
            this.TestedRules = true;
        } else if (this._details.equals("errors")) {
            this.Data = data;
            this.Errors = true;
        } else if (this._details.equals("newErrors")) {
            this.Data = data;
            this.NewErrors = true;
        } else if (this._details.equals("fixedErrors")) {
            this.Data = data;
            this.FixedErrors = true;
        } else if (this._details.equals("unfixedErrors")) {
            this.Data = data;
            this.NotFixedErrors = true;
        } else if (this._details.equals("patterns")) {
            this.Data = data;
            this.Patterns = true;
            this.isEntry = false;
        }
    }

    public boolean isTestedRules() {
        return this.TestedRules;
    }

    public boolean isErrors() {
        return this.Errors;
    }

    public boolean isNewErrors() {
        return this.NewErrors;
    }

    public boolean isFixedErrors() {
        return this.FixedErrors;
    }

    public boolean isNotFixedErrors() {
        return this.NotFixedErrors;
    }

    public boolean isPatterns() {
        return this.Patterns;
    }

    public boolean isEntry() {
        return this.isEntry;
    }

    private void createGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        System.out.println("execution de ProjectDetail.createGraph()");
        AbstractResultAction action = (AbstractResultAction)this.getLastAction();
        if (action == null) {
            response.setStatus(404);
        } else {
            action.doDetailsGraph(request, response, this._details);
        }
    }

    public void doTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        System.out.println("execution de ProjectDetail.doTrend()");
        this.createGraph(request, response);
    }

    public ResultAction<?> getLastAction() {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        if (lastBuild != null) {
            return (ResultAction)lastBuild.getAction(SerenitecResultAction.class);
        }
        return null;
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this._project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(SerenitecResultAction.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this._owner;
    }

    public String getDisplayName() {
        return this.titre;
    }

    private void setDisplayName() {
        if (this._details.startsWith("testedRules")) {
            this.titre = "Tested Rules trend";
        }
    }
}

