/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util;

import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.plugins.serenitec.SerenitecDescriptor;
import hudson.plugins.serenitec.parseur.ReportEntry;
import hudson.plugins.serenitec.util.HealthReportBuilder;
import hudson.plugins.serenitec.util.ResultAction;
import hudson.plugins.serenitec.util.ToolTipProvider;
import hudson.plugins.serenitec.util.model.EntriesProvider;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultAction<T extends EntriesProvider>
implements StaplerProxy,
HealthReportingAction,
ToolTipProvider,
ResultAction<T> {
    private static final long serialVersionUID = -7201451538713818948L;
    private static final int WIDTH = 500;
    private final AbstractBuild<?, ?> owner;
    private HealthReportBuilder healthReportBuilder;
    private T result;

    public AbstractResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder) {
        this.owner = owner;
        this.healthReportBuilder = healthReportBuilder;
    }

    public AbstractResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder, T result) {
        this(owner, healthReportBuilder);
        this.result = result;
    }

    protected CategoryDataset buildDataSet(boolean useHealthBuilder) {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractResultAction<T> action = this; action != null; action = action.getPreviousBuild()) {
            Object current = action.getResult();
            if (current == null) continue;
            ArrayList<Integer> series = new ArrayList<Integer>();
            series.add(current.getNumberOfSeverityFormatage());
            series.add(current.getNumberOfSeverityPerformance());
            series.add(current.getNumberOfSeverityDesign());
            series.add(current.getNumberOfSeverityLowSecurity());
            series.add(current.getNumberOfSeverityHighSecurity());
            int level = 0;
            for (Integer integer : series) {
                builder.add((Number)integer, (Comparable)Integer.valueOf(level), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.getOwner()));
                ++level;
            }
        }
        return builder.build();
    }

    protected CategoryDataset buildDetailsDataSet(boolean useHealthBuilder, String param) {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractResultAction<T> action = this; action != null; action = action.getPreviousBuild()) {
            Object current = action.getResult();
            if (current == null) continue;
            ArrayList<Integer> series = new ArrayList<Integer>();
            if (param.equals("testedRules")) {
                series.add(current.getNumberOfRules());
            } else if (param.equals("errors")) {
                series.add(current.getNumberOfEntry());
            } else if (param.equals("newErrors")) {
                series.add(current.getNumberOfNewEntry());
            } else if (param.equals("fixedErrors")) {
                series.add(current.getNumberOfFixedEntry());
            } else if (param.equals("unfixedErrors")) {
                series.add(current.getNumberOfNotFixedEntry());
            } else if (param.equals("patterns")) {
                series.add(current.getNumberOfPointeurs());
            }
            int level = 0;
            for (Integer integer : series) {
                builder.add((Number)integer, (Comparable)Integer.valueOf(level), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.getOwner()));
                ++level;
            }
        }
        return builder.build();
    }

    private JFreeChart createChart(StaplerRequest request, StaplerResponse response) {
        System.out.println("---createChart------");
        String parameter = request.getParameter("useHealthBuilder");
        boolean useHealthBuilder = Boolean.valueOf(StringUtils.defaultIfEmpty((String)parameter, (String)"true"));
        return this.getHealthReportBuilder().createGraph(useHealthBuilder, this.getDescriptor().getPluginResultUrlName(), this.buildDataSet(useHealthBuilder), this);
    }

    private JFreeChart createRulesRepartitionChart(StaplerRequest request, StaplerResponse response, int n1, int n2, String titre) {
        JFreeChart chart = null;
        DefaultPieDataset pieDataset = new DefaultPieDataset();
        pieDataset.setValue((Comparable)((Object)(titre + "(" + (float)n1 * 100.0f / (float)n2 + "%)")), (double)n1);
        pieDataset.setValue((Comparable)((Object)"Remains"), (double)(n2 - n1));
        chart = ChartFactory.createPieChart3D(null, (PieDataset)pieDataset, (boolean)false, (boolean)true, (boolean)false);
        PiePlot3D p = (PiePlot3D)chart.getPlot();
        p.setForegroundAlpha(0.5f);
        return chart;
    }

    private JFreeChart createPersonalChart(StaplerRequest request, StaplerResponse response, String type) {
        JFreeChart chart = null;
        if (type.equals("errorBySeverityTrend")) {
            System.out.println("errorBySeverityTrend");
            DefaultPieDataset pieDataset = new DefaultPieDataset();
            pieDataset.setValue((Comparable)((Object)"Formating"), (double)this.getResult().getNumberOfSeverityFormatage());
            pieDataset.setValue((Comparable)((Object)"Language evolution"), (double)this.getResult().getNumberOfSeverityPerformance());
            pieDataset.setValue((Comparable)((Object)"Design"), (double)this.getResult().getNumberOfSeverityDesign());
            pieDataset.setValue((Comparable)((Object)"Low Security"), (double)this.getResult().getNumberOfSeverityLowSecurity());
            pieDataset.setValue((Comparable)((Object)"High Security"), (double)this.getResult().getNumberOfSeverityHighSecurity());
            chart = ChartFactory.createPieChart3D((String)"Errors by Severity", (PieDataset)pieDataset, (boolean)false, (boolean)true, (boolean)false);
            PiePlot3D p = (PiePlot3D)chart.getPlot();
            p.setForegroundAlpha(0.5f);
        } else if (type.equals("patternsBySeverityTrend")) {
            System.out.println("patternsBySeverityTrend");
            DefaultPieDataset pieDataset = new DefaultPieDataset();
            pieDataset.setValue((Comparable)((Object)"Formating"), (double)this.getResult().getNumberOfSeverityFormatagePatterns());
            pieDataset.setValue((Comparable)((Object)"Language evolution"), (double)this.getResult().getNumberOfSeverityPerformancePatterns());
            pieDataset.setValue((Comparable)((Object)"Design"), (double)this.getResult().getNumberOfSeverityDesignPatterns());
            pieDataset.setValue((Comparable)((Object)"Low Security"), (double)this.getResult().getNumberOfSeverityLowSecurityPatterns());
            pieDataset.setValue((Comparable)((Object)"High Security"), (double)this.getResult().getNumberOfSeverityHighSecurityPatterns());
            chart = ChartFactory.createPieChart3D((String)"Patterns by Severity", (PieDataset)pieDataset, (boolean)false, (boolean)true, (boolean)false);
            PiePlot3D p = (PiePlot3D)chart.getPlot();
            p.setForegroundAlpha(0.5f);
        } else if (type.equals("topFiveTrend")) {
            System.out.println("patternsBySeverityTrend");
            DefaultCategoryDataset categorieDataset = new DefaultCategoryDataset();
            int numberOfPatternsForTopFive = 0;
            int numberOfPatternsForNotTopFive = 0;
            for (ReportEntry topfiveEntry : this.getResult().getTopFiveEntries()) {
                numberOfPatternsForTopFive += topfiveEntry.getNumberOfPointeurs();
            }
            numberOfPatternsForNotTopFive = this.getResult().getNumberOfPointeurs() - numberOfPatternsForTopFive;
            categorieDataset.addValue((double)numberOfPatternsForTopFive, (Comparable)((Object)("TopFive (" + (float)numberOfPatternsForTopFive * 100.0f / (float)this.getResult().getNumberOfPointeurs() + "%)")), (Comparable)((Object)"Patterns"));
            categorieDataset.addValue((double)numberOfPatternsForNotTopFive, (Comparable)((Object)("Remains (" + (float)numberOfPatternsForNotTopFive * 100.0f / (float)this.getResult().getNumberOfPointeurs() + "%)")), (Comparable)((Object)"Patterns"));
            chart = ChartFactory.createStackedBarChart3D(null, null, null, (CategoryDataset)categorieDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
            CategoryPlot plot = (CategoryPlot)chart.getPlot();
            CategoryItemRenderer renderer = plot.getRenderer();
            plot.setForegroundAlpha(0.5f);
            return chart;
        }
        return chart;
    }

    private JFreeChart createDetailsChart(StaplerRequest request, StaplerResponse response, String param) {
        System.out.println("---createRepositoryChart------");
        return this.getHealthReportBuilder().createGraph(false, this.getDescriptor().getPluginResultUrlName(), this.buildDetailsDataSet(false, param), this);
    }

    @Override
    public final void doGraph(StaplerRequest request, StaplerResponse response, int height) throws IOException {
        System.out.println("---doGraph------");
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request, response), (int)500, (int)height);
    }

    @Override
    public final void doPersonalGraph(StaplerRequest request, StaplerResponse response, int height, String type) throws IOException {
        System.out.println("---doGraph------");
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        int width = 400;
        if (type.equals("topFiveTrend")) {
            width = 800;
            height = 100;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createPersonalChart(request, response, type), (int)width, (int)height);
    }

    @Override
    public final void doRulesRepartitionPie(StaplerRequest request, StaplerResponse response, int size, int n1, int n2, String titre) throws IOException {
        System.out.println("---doGraph------");
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createRulesRepartitionChart(request, response, n1, n2, titre), (int)300, (int)150);
    }

    public void doDetailsGraph(StaplerRequest request, StaplerResponse response, String param) throws IOException {
        System.out.println("---doRepositoryGraph------");
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createDetailsChart(request, response, param), (int)850, (int)200);
    }

    @Override
    public final void doGraphMap(StaplerRequest request, StaplerResponse response, int height) throws IOException {
        ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request, response), (int)500, (int)height);
    }

    public final HealthReport getBuildHealth() {
        return this.healthReportBuilder.computeHealth(this.getResult().getNumberOfPointeurs() - this.getPreviousBuild().getResult().getNumberOfPointeurs());
    }

    protected abstract SerenitecDescriptor getDescriptor();

    @Override
    public final HealthReportBuilder getHealthReportBuilder() {
        if (this.healthReportBuilder == null) {
            this.healthReportBuilder = new HealthReportBuilder();
        }
        return this.healthReportBuilder;
    }

    public String getIconFileName() {
        String resultat = null;
        if (this.getResult().getNumberOfEntry() > 0) {
            resultat = this.getDescriptor().getIconUrl();
        }
        return resultat;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    protected AbstractResultAction<T> getPreviousBuild() {
        AbstractResultAction action;
        AbstractBuild build = this.getOwner();
        do {
            if ((build = (AbstractBuild)build.getPreviousBuild()) != null) continue;
            return null;
        } while ((action = (AbstractResultAction)build.getAction(this.getClass())) == null);
        return action;
    }

    @Override
    public final T getResult() {
        return this.result;
    }

    public final Object getTarget() {
        return this.getResult();
    }

    public String getUrlName() {
        return this.getDescriptor().getPluginResultUrlName();
    }

    @Override
    public boolean hasPreviousResultAction() {
        return this.getPreviousBuild() != null;
    }

    @Override
    public final void setResult(T result) {
        this.result = result;
    }
}

