/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util;

import hudson.util.ColorPalette;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryLineAnnotation;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleInsets;

public final class ChartBuilder {
    public static JFreeChart createChart(CategoryDataset dataset, StackedAreaRenderer renderer, int threshold, boolean isThreeColor) {
        JFreeChart chart = ChartBuilder.createChart(dataset);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRenderer((CategoryItemRenderer)renderer);
        if (dataset.getRowCount() == 1) {
            renderer.setSeriesPaint(0, (Paint)new Color(244, 188, 88));
        } else if (dataset.getRowCount() == 2) {
            renderer.setSeriesPaint(0, (Paint)new Color(244, 188, 88));
            renderer.setSeriesPaint(1, (Paint)new Color(128, 185, 194));
        } else {
            renderer.setSeriesPaint(4, (Paint)new Color(168, 129, 61));
            renderer.setSeriesPaint(3, (Paint)new Color(244, 188, 88));
            renderer.setSeriesPaint(2, (Paint)new Color(128, 185, 194));
            renderer.setSeriesPaint(1, (Paint)new Color(219, 250, 255));
            renderer.setSeriesPaint(0, (Paint)new Color(245, 245, 245));
        }
        ChartBuilder.annotateThreshold(chart, dataset, threshold);
        return chart;
    }

    public static JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public static JFreeChart createHighNormalLowChart(int format, int performance, int design, int max) {
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset((String)"row", (String)"column", (double[][])new double[][]{{format}, {performance}, {design}});
        JFreeChart chart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(false);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(false);
        CategoryAxis domainAxis = new CategoryAxis();
        plot.setDomainAxis(domainAxis);
        domainAxis.setVisible(false);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        plot.getRenderer().setSeriesPaint(0, (Paint)ColorPalette.RED);
        plot.getRenderer().setSeriesPaint(1, (Paint)ColorPalette.YELLOW);
        plot.getRenderer().setSeriesPaint(2, (Paint)ColorPalette.BLUE);
        plot.getRenderer().setSeriesOutlineStroke(0, (Stroke)new BasicStroke(0.0f));
        plot.getRenderer().setSeriesOutlineStroke(1, (Stroke)new BasicStroke(0.0f));
        plot.getRenderer().setSeriesOutlineStroke(2, (Stroke)new BasicStroke(0.0f));
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setVisible(false);
        rangeAxis.setLowerMargin(0.0);
        rangeAxis.setUpperMargin(0.0);
        rangeAxis.setUpperBound((double)max);
        return chart;
    }

    private static void annotateThreshold(JFreeChart chart, CategoryDataset dataset, int threshold) {
        if (threshold > 0) {
            CategoryPlot plot = chart.getCategoryPlot();
            plot.addAnnotation((CategoryAnnotation)new CategoryLineAnnotation(dataset.getColumnKey(0), (double)threshold, dataset.getColumnKey(dataset.getColumnCount() - 1), (double)threshold, (Paint)Color.BLACK, (Stroke)new BasicStroke()));
            Range range = DatasetUtilities.findRangeBounds((CategoryDataset)dataset);
            plot.addAnnotation((CategoryAnnotation)new CategoryTextAnnotation("unstable threshold", dataset.getColumnKey(dataset.getColumnCount() / 2), (double)threshold + range.getLength() * 0.1));
        }
    }

    private ChartBuilder() {
    }
}

