/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.serenitec.util.HealthReportBuilder;
import hudson.plugins.serenitec.util.Project;
import hudson.plugins.serenitec.util.TrendReportSize;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HealthAwarePublisher
extends Publisher {
    private final String severityMax;
    private boolean thresholdEnabled;
    private int minimumAnnotations;
    private final String healthy;
    private final String unHealthy;
    private int healthyPatterns;
    private int unHealthyPatterns;
    private boolean healthyReportEnabled;
    private final String height;
    private final String pluginName;

    public HealthAwarePublisher(String severityMax, String healthy, String unHealthy, String height, String pluginName) {
        this.severityMax = severityMax;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.height = height;
        this.pluginName = "[" + pluginName + "] ";
        if (!StringUtils.isEmpty((String)severityMax)) {
            try {
                this.minimumAnnotations = Integer.valueOf(severityMax);
                if (this.minimumAnnotations >= 0) {
                    this.thresholdEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)healthy) && !StringUtils.isEmpty((String)unHealthy)) {
            try {
                this.healthyPatterns = Integer.valueOf(healthy);
                this.unHealthyPatterns = Integer.valueOf(unHealthy);
                this.healthyReportEnabled = true;
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    protected HealthReportBuilder createHealthReporter(String reportSingleCount, String reportMultipleCount) {
        return new HealthReportBuilder(this.thresholdEnabled, this.minimumAnnotations, true, this.healthyPatterns, this.unHealthyPatterns, reportSingleCount, reportMultipleCount);
    }

    private void evaluateBuildResult(AbstractBuild<?, ?> build, PrintStream logger, Project project) {
        int numberOfEntry = project.getNumberOfEntry();
        int severityMaxDiscovered = project.getMaxSeverityDiscovered();
        if (numberOfEntry > 0) {
            if (this.isThresholdEnabled() && severityMaxDiscovered > Integer.parseInt(this.getseverityMax()) && !project.IsFixed()) {
                build.setResult(Result.UNSTABLE);
            }
        } else {
            this.log(logger, "No entry have been found.");
        }
    }

    public String getHealthy() {
        return this.healthy;
    }

    public int getHealthyPatterns() {
        return this.healthyPatterns;
    }

    public String getHeight() {
        return this.height;
    }

    public int getMinimumAnnotations() {
        return this.minimumAnnotations;
    }

    public String getseverityMax() {
        return this.severityMax;
    }

    public int getTrendHeight() {
        return new TrendReportSize(this.height).getHeight();
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public int getUnHealthyPatterns() {
        return this.unHealthyPatterns;
    }

    public boolean isHealthyReportEnabled() {
        return this.healthyReportEnabled;
    }

    public boolean isThresholdEnabled() {
        return this.thresholdEnabled;
    }

    protected void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)this.pluginName) + message);
    }

    public final boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        if (this.canContinue(build.getResult())) {
            try {
                Project project = this.perform(build, logger);
                this.evaluateBuildResult(build, logger, project);
            }
            catch (Exception exception) {
                this.log(logger, "Error : " + exception.toString());
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        return true;
    }

    protected abstract Project perform(AbstractBuild<?, ?> var1, PrintStream var2) throws InterruptedException, IOException;
}

