/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.serenitec.util;

import hudson.plugins.serenitec.util.model.EntriesContainer;
import hudson.plugins.serenitec.util.model.MavenModule;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends EntriesContainer {
    private static final long serialVersionUID = 771741031245139227L;
    private String workspacePath;
    private boolean hasModuleError;
    private String error;

    public Project() {
        super(EntriesContainer.Hierarchy.PROJECT);
    }

    public void addError(String additionalError) {
        this.error = StringUtils.isEmpty((String)this.error) ? additionalError : this.error + "\n" + additionalError;
    }

    public void addModule(MavenModule module) {
        this.addEntries(module.getEntries());
        if (module.hasError()) {
            this.hasModuleError = true;
            this.addError(module.getError());
        }
    }

    public void addModules(Collection<MavenModule> modules) {
        for (MavenModule mavenModule : modules) {
            this.addModule(mavenModule);
        }
    }

    @Override
    protected Collection<? extends EntriesContainer> getChildren() {
        return this.getModules();
    }

    public String getError() {
        return this.error;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public boolean hasError() {
        return this.hasModuleError || this.error != null;
    }

    private Object readResolve() {
        this.setHierarchy(EntriesContainer.Hierarchy.PROJECT);
        this.rebuildMappings();
        return this;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setWorkspacePath(String workspacePath) {
        this.workspacePath = workspacePath;
    }
}

