/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity;

import com.ikokoon.serenity.Configuration;
import com.ikokoon.serenity.IConstants;
import com.ikokoon.serenity.hudson.source.CoverageSourceCode;
import com.ikokoon.serenity.model.Afferent;
import com.ikokoon.serenity.model.Class;
import com.ikokoon.serenity.model.Composite;
import com.ikokoon.serenity.model.Efferent;
import com.ikokoon.serenity.model.Line;
import com.ikokoon.serenity.model.Method;
import com.ikokoon.serenity.model.Package;
import com.ikokoon.serenity.model.Project;
import com.ikokoon.serenity.persistence.DataBaseRam;
import com.ikokoon.serenity.persistence.IDataBase;
import com.ikokoon.toolkit.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Collector
implements IConstants {
    private static final Logger LOGGER = Logger.getLogger(Collector.class);
    private static IDataBase dataBase = IDataBase.DataBaseManager.getDataBase(DataBaseRam.class, (String)"./serenity/serenity.ram", (boolean)false, null);

    public static final void collectCoverage(String className, String methodName, String methodDescription, int lineNumber) {
        Line line = Collector.getLine((String)className, (String)methodName, (String)methodDescription, (double)lineNumber);
        line.increment();
    }

    public static final void collectLines(String className, String methodName, String methodDescription, Integer lineNumber) {
        Collector.getLine((String)className, (String)methodName, (String)methodDescription, (double)lineNumber.intValue());
    }

    public static final void collectSource(String className, String source) {
        Class klass = Collector.getClass((String)className);
        File file = new File("./serenity/source", className + ".html");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Exception creating the source HTML file", (Throwable)e);
            }
        }
        if (file.exists()) {
            CoverageSourceCode sourceCode = new CoverageSourceCode(klass, source);
            String htmlSource = sourceCode.getSource();
            Toolkit.setContents((File)file, (byte[])htmlSource.getBytes());
        }
    }

    public static final void collectComplexity(String className, String methodName, String methodDescription, double complexity) {
        Method method = Collector.getMethod((String)className, (String)methodName, (String)methodDescription);
        method.setComplexity(complexity);
    }

    public static final void collectEfferentAndAfferent(String className, String ... targetClassNames) {
        String packageName = Toolkit.classNameToPackageName((String)className);
        for (String targetClassName : targetClassNames) {
            String targetPackageName = Toolkit.classNameToPackageName((String)targetClassName);
            if (targetPackageName.trim().equals("") || targetPackageName.equals(packageName) || Configuration.getConfiguration().excluded(packageName) || Configuration.getConfiguration().excluded(targetPackageName)) continue;
            Class klass = Collector.getClass((String)className);
            Afferent afferent = Collector.getAfferent((Class)klass, (String)targetPackageName);
            if (!klass.getAfferent().contains(afferent)) {
                klass.getAfferent().add(afferent);
            }
            Class targetClass = Collector.getClass((String)targetClassName);
            Efferent efferent = Collector.getEfferent((Class)targetClass, (String)packageName);
            if (targetClass.getEfferent().contains(efferent)) continue;
            targetClass.getEfferent().add(efferent);
        }
    }

    public static final void collectInterface(String className, Integer access) {
        Class klass;
        if (access == 1537 && !(klass = Collector.getClass((String)className)).getInterfaze()) {
            klass.setInterfaze(true);
        }
    }

    public static final void collectInnerClass(String innerName, String outerName) {
        Class innerClass = Collector.getClass((String)innerName);
        Class outerClass = Collector.getClass((String)outerName);
        if (innerClass.getOuterClass() == null) {
            innerClass.setOuterClass(outerClass);
        }
        if (!outerClass.getInnerClasses().contains(innerClass)) {
            outerClass.getInnerClasses().add(innerClass);
        }
    }

    public static final void collectOuterClass(String innerName, String outerName, String outerMethodName, String outerMethodDescription) {
        Class innerClass = Collector.getClass((String)innerName);
        Class outerClass = Collector.getClass((String)outerName);
        if (innerClass.getOuterClass() == null) {
            innerClass.setOuterClass(outerClass);
        }
        if (!outerClass.getInnerClasses().contains(innerClass)) {
            outerClass.getInnerClasses().add(innerClass);
        }
        if (innerClass.getOuterMethod() == null && outerMethodName != null) {
            Method outerMethod = Collector.getMethod((String)outerName, (String)outerMethodName, (String)outerMethodDescription);
            innerClass.setOuterMethod(outerMethod);
        }
    }

    private static final Package<Project<?, ?>, Class<?, ?>> getPackage(String className) {
        String packageName = Toolkit.classNameToPackageName((String)className);
        long id = Toolkit.hash((String)packageName);
        Package pakkage = (Package)dataBase.find(Package.class, Long.valueOf(id));
        if (pakkage == null) {
            pakkage = new Package();
            pakkage.setName(packageName);
            pakkage.setComplexity(1.0);
            pakkage.setCoverage(0.0);
            pakkage.setAbstractness(0.0);
            pakkage.setStability(0.0);
            pakkage.setDistance(0.0);
            pakkage.setInterfaces(0.0);
            pakkage.setImplementations(0.0);
            pakkage = (Package)dataBase.persist((Composite)pakkage);
            LOGGER.debug((Object)("Added package : " + pakkage));
        }
        return pakkage;
    }

    private static final Class<Package<?, ?>, Method<?, ?>> getClass(String className) {
        long id = Toolkit.hash((String)className);
        Class klass = (Class)dataBase.find(Class.class, Long.valueOf(id));
        if (klass == null) {
            klass = new Class();
            klass.setName(className);
            klass.setComplexity(1.0);
            klass.setCoverage(0.0);
            klass.setStability(0.0);
            klass.setEfference(0.0);
            klass.setAfference(0.0);
            klass.setInterfaze(false);
            Package pakkage = Collector.getPackage((String)className);
            pakkage.getChildren().add(klass);
            klass.setParent((Composite)pakkage);
            klass = (Class)dataBase.persist((Composite)klass);
            LOGGER.debug((Object)("Added class  : " + klass));
        }
        return klass;
    }

    private static final Method<?, ?> getMethod(String className, String methodName, String methodDescription) {
        methodName = methodName.replace('<', ' ').replace('>', ' ').trim();
        long id = Toolkit.hash((Object[])new Object[]{className, methodName, methodDescription});
        Method method = (Method)dataBase.find(Method.class, Long.valueOf(id));
        if (method == null) {
            method = new Method();
            method.setName(methodName);
            method.setClassName(className);
            method.setDescription(methodDescription);
            method.setComplexity(0.0);
            method.setCoverage(0.0);
            Class klass = Collector.getClass((String)className);
            method.setParent((Composite)klass);
            if (klass.getChildren() == null) {
                ArrayList children = new ArrayList();
                klass.setChildren(children);
            }
            klass.getChildren().add(method);
            dataBase.persist((Composite)method);
        }
        return method;
    }

    protected static final Line<?, ?> getLine(String className, String methodName, String methodDescription, double lineNumber) {
        long id = Toolkit.hash((Object[])new Object[]{className, methodName, lineNumber});
        Line line = (Line)dataBase.find(Line.class, Long.valueOf(id));
        if (line == null) {
            line = new Line();
            line.setNumber(lineNumber);
            line.setCounter(0.0);
            line.setClassName(className);
            line.setMethodName(methodName);
            Method method = Collector.getMethod((String)className, (String)methodName, (String)methodDescription);
            List lines = method.getChildren();
            line.setParent((Composite)method);
            lines.add(line);
            dataBase.persist((Composite)line);
        }
        return line;
    }

    private static final Efferent getEfferent(Class<?, ?> klass, String packageName) {
        StringBuilder builder = new StringBuilder("<e:");
        builder.append(packageName);
        builder.append(">");
        String name = builder.toString();
        long id = Toolkit.hash((String)name);
        Efferent efferent = (Efferent)dataBase.find(Efferent.class, Long.valueOf(id));
        if (efferent == null) {
            efferent = new Efferent();
            efferent.setName(name);
            klass.getEfferent().add(efferent);
            dataBase.persist((Composite)efferent);
        }
        return efferent;
    }

    private static final Afferent getAfferent(Class<?, ?> klass, String packageName) {
        StringBuilder builder = new StringBuilder("<a:");
        builder.append(packageName);
        builder.append(">");
        String name = builder.toString();
        long id = Toolkit.hash((String)name);
        Afferent afferent = (Afferent)dataBase.find(Afferent.class, Long.valueOf(id));
        if (afferent == null) {
            afferent = new Afferent();
            afferent.setName(name);
            klass.getAfferent().add(afferent);
            dataBase.persist((Composite)afferent);
        }
        return afferent;
    }
}

