/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity;

import com.ikokoon.serenity.LoggingConfigurator;
import com.ikokoon.serenity.instrumentation.complexity.ComplexityClassAdapter;
import com.ikokoon.serenity.instrumentation.coverage.CoverageClassAdapter;
import com.ikokoon.serenity.instrumentation.dependency.DependencyClassAdapter;
import com.ikokoon.serenity.instrumentation.profiling.ProfilingClassAdapter;
import com.ikokoon.serenity.model.Project;
import com.ikokoon.toolkit.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.objectweb.asm.ClassVisitor;

public class Configuration {
    private static Configuration configuration = new Configuration();
    public Logger logger;
    public Set<String> includedPackages = new TreeSet();
    public Set<String> excludedPackages = new TreeSet();
    public List<Class<ClassVisitor>> classAdapters = new ArrayList();

    public static synchronized Configuration getConfiguration() {
        return configuration;
    }

    private Configuration() {
        LoggingConfigurator.configure();
        this.logger = Logger.getLogger(this.getClass());
        this.addIncludedPackages();
        this.addExcludedPackages();
        this.addIncludedClassAdapters();
        this.addDefaultExcludedPackages();
    }

    public boolean included(String string) {
        if (string == null) {
            return false;
        }
        string = Toolkit.slashToDot((String)string);
        for (String pattern : this.includedPackages) {
            if (string.indexOf(pattern) <= -1) continue;
            return true;
        }
        return false;
    }

    public boolean excluded(String string) {
        if (string == null) {
            return true;
        }
        string = Toolkit.slashToDot((String)string);
        for (String pattern : this.excludedPackages) {
            if (string.indexOf(pattern) <= -1) continue;
            return true;
        }
        return false;
    }

    public String getProperty(String name) {
        return System.getProperty(name);
    }

    public String getClassPath() {
        StringBuilder builder = new StringBuilder();
        String classpath = System.getProperty("java.class.path");
        builder.append(classpath);
        String surefireClasspath = System.getProperty("surefire.test.class.path");
        if (surefireClasspath != null) {
            builder.append(File.pathSeparator);
            builder.append(surefireClasspath);
        }
        String includedJars = System.getProperty("included.jars");
        this.logger.debug((Object)("Included jars : " + includedJars));
        if (includedJars != null) {
            StringTokenizer tokenizer = new StringTokenizer(includedJars, ";:", false);
            while (tokenizer.hasMoreTokens()) {
                String jarFile = tokenizer.nextToken();
                builder.append(File.pathSeparator);
                builder.append(jarFile);
            }
        }
        return builder.toString();
    }

    private void addIncludedPackages() {
        String packageNames = System.getProperty("included.packages");
        this.logger.debug((Object)("Package names : " + packageNames));
        if (packageNames != null) {
            StringTokenizer tokenizer = new StringTokenizer(packageNames, ";: ", false);
            while (tokenizer.hasMoreTokens()) {
                String packageName = tokenizer.nextToken();
                packageName = Toolkit.stripWhitespace((String)packageName);
                this.includedPackages.add(packageName);
                this.logger.debug((Object)("Added package to enhance : " + packageName));
            }
        }
    }

    private void addExcludedPackages() {
        String excludedPatterns = System.getProperty("excluded.packages");
        if (excludedPatterns != null) {
            StringTokenizer tokenizer = new StringTokenizer(excludedPatterns, ";: ", false);
            while (tokenizer.hasMoreTokens()) {
                String excludedPattern = tokenizer.nextToken();
                this.excludedPackages.add(excludedPattern);
            }
        }
    }

    private void addIncludedClassAdapters() {
        String adapterNames = System.getProperty("included.adapters");
        if (adapterNames != null) {
            StringTokenizer tokenizer = new StringTokenizer(adapterNames, ";: ", false);
            while (tokenizer.hasMoreTokens()) {
                String adapterName = tokenizer.nextToken();
                adapterName = Toolkit.stripWhitespace((String)adapterName);
                try {
                    if (adapterName.equals("coverage")) {
                        this.classAdapters.add(Class.forName(CoverageClassAdapter.class.getName()));
                    }
                    if (adapterName.equals("complexity")) {
                        this.classAdapters.add(Class.forName(ComplexityClassAdapter.class.getName()));
                    }
                    if (adapterName.equals("dependency")) {
                        this.classAdapters.add(Class.forName(DependencyClassAdapter.class.getName()));
                    }
                    if (!adapterName.equals("profiling")) continue;
                    this.classAdapters.add(Class.forName(ProfilingClassAdapter.class.getName()));
                }
                catch (ClassNotFoundException e) {
                    this.logger.error((Object)("Class : " + adapterName + " not found"), (Throwable)e);
                }
            }
        }
    }

    private void addDefaultExcludedPackages() {
        this.excludedPackages.add("java.lang");
        this.excludedPackages.add("sun");
        this.excludedPackages.add("sunw");
        this.excludedPackages.add("com.sun");
        this.excludedPackages.add("Test");
        this.excludedPackages.add(Project.class.getPackage().getName());
    }
}

