/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity;

import com.ikokoon.serenity.Configuration;
import com.ikokoon.serenity.IConstants;
import com.ikokoon.serenity.LoggingConfigurator;
import com.ikokoon.serenity.instrumentation.VisitorFactory;
import com.ikokoon.serenity.persistence.DataBaseOdb;
import com.ikokoon.serenity.persistence.DataBaseRam;
import com.ikokoon.serenity.persistence.DataBaseToolkit;
import com.ikokoon.serenity.persistence.IDataBase;
import com.ikokoon.toolkit.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer
implements ClassFileTransformer,
IConstants {
    private static Logger LOGGER;
    private static boolean INITIALISED;
    private static Class<ClassVisitor>[] CLASS_ADAPTER_CLASSES;

    public static void premain(String args, Instrumentation instrumentation) {
        if (!INITIALISED) {
            String cleanClasses;
            INITIALISED = true;
            LoggingConfigurator.configure();
            CLASS_ADAPTER_CLASSES = Configuration.getConfiguration().classAdapters.toArray(new Class[Configuration.getConfiguration().classAdapters.size()]);
            LOGGER = Logger.getLogger(Transformer.class);
            Runtime.getRuntime().addShutdownHook((Thread)new /* Unavailable Anonymous Inner Class!! */);
            if (instrumentation != null) {
                instrumentation.addTransformer((ClassFileTransformer)new Transformer());
            }
            if ((cleanClasses = Configuration.getConfiguration().getProperty("clean.classes")) != null && cleanClasses.equals(Boolean.TRUE.toString())) {
                File serenityDirectory = new File("./serenity");
                Toolkit.deleteFiles((File)serenityDirectory, (String[])new String[]{".class"});
                if (!serenityDirectory.exists() && !serenityDirectory.mkdirs()) {
                    LOGGER.warn((Object)("Didn't re-create Serenity directory : " + serenityDirectory.getAbsolutePath()));
                }
            }
            IDataBase odbDataBase = IDataBase.DataBaseManager.getDataBase(DataBaseOdb.class, (String)"./serenity/serenity.odb", (boolean)true, null);
            IDataBase ramDataBase = IDataBase.DataBaseManager.getDataBase(DataBaseRam.class, (String)"./serenity/serenity.ram", (boolean)true, (IDataBase)odbDataBase);
            DataBaseToolkit.clear((IDataBase)ramDataBase);
        }
    }

    protected static void printSystemProperties() {
        System.out.println("Working directory : " + new File(".").getAbsolutePath());
        System.out.println("Java class path : " + System.getProperty("java.class.path"));
        Enumeration<Object> keys = System.getProperties().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key == null) continue;
            System.out.println("System property : " + key + "=" + System.getProperties().getProperty(key.toString()));
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classBytes) throws IllegalClassFormatException {
        if (loader != ClassLoader.getSystemClassLoader()) {
            LOGGER.debug((Object)("No system classloader : " + className));
            return classBytes;
        }
        if (Configuration.getConfiguration().excluded(className)) {
            LOGGER.debug((Object)("Excluded class : " + className));
            return classBytes;
        }
        if (Configuration.getConfiguration().included(className)) {
            LOGGER.debug((Object)("Enhancing class : " + className));
            ByteArrayOutputStream source = new ByteArrayOutputStream(0);
            ClassWriter writer = (ClassWriter)VisitorFactory.getClassVisitor((Class[])CLASS_ADAPTER_CLASSES, (String)className, (byte[])classBytes, (ByteArrayOutputStream)source);
            byte[] enhancedClassBytes = writer.toByteArray();
            String writeClasses = Configuration.getConfiguration().getProperty("write.classes");
            if (writeClasses != null && writeClasses.equals(Boolean.TRUE.toString())) {
                this.writeClass(className, enhancedClassBytes);
            }
            return enhancedClassBytes;
        }
        LOGGER.debug((Object)("Class not included : " + className));
        return classBytes;
    }

    private void writeClass(String className, byte[] classBytes) {
        String directoryPath = Toolkit.dotToSlash((String)Toolkit.classNameToPackageName((String)className));
        String fileName = className.replaceFirst(Toolkit.classNameToPackageName((String)className), "") + ".class";
        File directory = new File("./serenity" + File.separator + directoryPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        LOGGER.debug((Object)directory.getAbsolutePath());
        File file = new File(directory, fileName);
        Toolkit.setContents((File)file, (byte[])classBytes);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static {
        INITIALISED = false;
    }
}

