/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.hudson;

import com.ikokoon.serenity.hudson.ISerenityResult;
import com.ikokoon.serenity.hudson.SerenityResult;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.lang.ref.WeakReference;
import org.kohsuke.stapler.StaplerProxy;

public class SerenityBuildAction
implements StaplerProxy,
Action {
    private final AbstractBuild owner;
    private transient WeakReference<ISerenityResult> result;

    public SerenityBuildAction(AbstractBuild owner, ISerenityResult result) {
        if (owner == null) {
            throw new RuntimeException("Owner cannot be null");
        }
        this.setResult(result);
        this.owner = owner;
    }

    public String getDisplayName() {
        return "Serenity Report";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "serenity";
    }

    public Object getTarget() {
        return this.getResult();
    }

    public ISerenityResult getResult() {
        if (!this.hasResult()) {
            this.reloadReport();
        }
        if (!this.hasResult()) {
            return new SerenityResult(this.owner);
        }
        return (ISerenityResult)this.result.get();
    }

    private void setResult(ISerenityResult result) {
        this.result = new WeakReference<ISerenityResult>(result);
    }

    private boolean hasResult() {
        return this.result != null && this.result.get() != null;
    }

    private void reloadReport() {
        SerenityResult result = new SerenityResult(this.owner);
        this.setResult((ISerenityResult)result);
    }
}

