/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.hudson.modeller;

import com.ikokoon.serenity.hudson.modeller.IModeller;
import com.ikokoon.serenity.model.Class;
import com.ikokoon.serenity.model.Composite;
import com.ikokoon.serenity.model.Package;
import com.ikokoon.serenity.model.Project;
import com.ikokoon.toolkit.Toolkit;
import java.io.InputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighchartsModeller
implements IModeller {
    private Logger logger = Logger.getLogger(this.getClass());
    private String model;
    private String modelName;
    private Integer[] buildNumbers;

    public HighchartsModeller(String modelName, Integer ... buildNumbers) {
        this.modelName = modelName;
        this.buildNumbers = buildNumbers;
    }

    public String getModel() {
        return this.model;
    }

    public void visit(java.lang.Class<?> klass, Composite<?, ?> ... composites) {
        StringBuilder coverageData = new StringBuilder("[0.0,");
        StringBuilder complexityData = new StringBuilder("[0.0,");
        StringBuilder stabilityData = new StringBuilder("[0.0,");
        StringBuilder categoryData = new StringBuilder("['0',");
        Composite<?, ?> composite = null;
        for (int i = 0; i < composites.length; ++i) {
            composite = composites[i];
            if (composite instanceof Class) {
                coverageData.append(((Class)composite).getCoverage());
                complexityData.append(((Class)composite).getComplexity());
                stabilityData.append(((Class)composite).getStability());
            } else if (composite instanceof Package) {
                coverageData.append(((Package)composite).getCoverage());
                complexityData.append(((Package)composite).getComplexity());
                stabilityData.append(((Package)composite).getStability());
            } else if (composite instanceof Project) {
                coverageData.append(((Project)composite).getCoverage());
                complexityData.append(((Project)composite).getComplexity());
                stabilityData.append(((Project)composite).getStability());
            }
            categoryData.append("'");
            categoryData.append(this.buildNumbers[i]);
            categoryData.append("'");
            if (i + 1 >= composites.length) continue;
            coverageData.append(",");
            complexityData.append(",");
            stabilityData.append(",");
            categoryData.append(",");
        }
        coverageData.append("]");
        complexityData.append("]");
        stabilityData.append("]");
        categoryData.append("]");
        String compositeName = composite instanceof Project ? ((Project)composite).getName() : (composite instanceof Package ? ((Package)composite).getName() : (composite instanceof Class ? ((Class)composite).getName() : "What am I?"));
        InputStream inputStream = this.getClass().getResourceAsStream(this.modelName);
        this.model = Toolkit.getContents((InputStream)inputStream).toString();
        this.model = Toolkit.replaceAll((String)this.model, (String)"compositeName", (String)compositeName);
        this.model = Toolkit.replaceAll((String)this.model, (String)"coverageData", (String)coverageData.toString());
        this.model = Toolkit.replaceAll((String)this.model, (String)"complexityData", (String)complexityData.toString());
        this.model = Toolkit.replaceAll((String)this.model, (String)"stabilityData", (String)stabilityData.toString());
        this.model = Toolkit.replaceAll((String)this.model, (String)"categoryData", (String)categoryData.toString());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Composite name : " + compositeName + ", coverage data : " + coverageData + ", complexity data : " + complexityData + ", stability data : " + stabilityData + ", category data : " + categoryData));
            this.logger.warn((Object)("Model : " + this.model));
        }
    }
}

