/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.instrumentation;

import com.ikokoon.serenity.instrumentation.dependency.DependencyAnnotationAdapter;
import com.ikokoon.serenity.instrumentation.dependency.DependencySignatureAdapter;
import com.ikokoon.toolkit.ObjectFactory;
import java.io.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitorFactory {
    private static Logger LOGGER = Logger.getLogger(VisitorFactory.class);

    public static ClassVisitor getClassVisitor(Class<ClassVisitor>[] classAdapterClasses, String className, byte[] classBytes, ByteArrayOutputStream source) {
        ClassWriter writer;
        ClassReader reader = new ClassReader(classBytes);
        ClassWriter visitor = writer = new ClassWriter(reader, 1);
        for (Class<ClassVisitor> klass : classAdapterClasses) {
            Object[] parameters = new Object[]{visitor, className, classBytes, source};
            visitor = (ClassVisitor)ObjectFactory.getObject(klass, (Object[])parameters);
            LOGGER.debug((Object)("Adding class visitor : " + visitor));
        }
        reader.accept((ClassVisitor)visitor, 0);
        return writer;
    }

    public static MethodVisitor getMethodVisitor(MethodVisitor visitor, Class<?> klass, String className, String name, String desc) {
        Object[] parameters = new Object[]{visitor, className, name, desc};
        MethodVisitor adapter = (MethodVisitor)ObjectFactory.getObject(klass, (Object[])parameters);
        return adapter;
    }

    public static FieldVisitor getFieldVisitor(FieldVisitor visitor, Class<?> klass, String className, String description, String signature) {
        Object[] parameters = new Object[]{visitor, className, description, signature};
        FieldVisitor adapter = (FieldVisitor)ObjectFactory.getObject(klass, (Object[])parameters);
        return adapter;
    }

    public static SignatureVisitor getSignatureVisitor(String className, String signature) {
        SignatureReader reader = new SignatureReader(signature);
        DependencySignatureAdapter adapter = new DependencySignatureAdapter(className);
        reader.accept((SignatureVisitor)adapter);
        return adapter;
    }

    public static AnnotationVisitor getAnnotationVisitor(AnnotationVisitor visitor, String className, String description) {
        DependencyAnnotationAdapter adapter = new DependencyAnnotationAdapter(visitor, className, description);
        return adapter;
    }
}

