/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.instrumentation.complexity;

import com.ikokoon.serenity.instrumentation.VisitorFactory;
import com.ikokoon.serenity.instrumentation.complexity.ComplexityMethodAdapter;
import com.ikokoon.toolkit.Toolkit;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;

public class ComplexityClassAdapter
extends ClassAdapter {
    private Logger logger = Logger.getLogger(this.getClass());
    private String className;

    public ComplexityClassAdapter(ClassVisitor visitor, String className) {
        super(visitor);
        this.className = Toolkit.slashToDot((String)className);
        this.logger.debug((Object)("Constructor : " + className));
    }

    public void visit(int version, int access, String className, String signature, String superName, String[] interfaces) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visit : " + version + ", " + access + ", " + className + ", " + signature + ", " + superName));
            if (interfaces != null) {
                this.logger.debug((Object)Arrays.asList(interfaces).toString());
            }
        }
        super.visit(version, access, className, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDescription, String signature, String[] exceptions) {
        this.logger.debug((Object)("visitMethod : " + access + ", " + methodName + ", " + methodDescription + ", " + signature + ", " + exceptions));
        MethodVisitor methodVisitor = super.visitMethod(access, methodName, methodDescription, signature, exceptions);
        MethodAdapter methodAdapter = (MethodAdapter)VisitorFactory.getMethodVisitor((MethodVisitor)methodVisitor, ComplexityMethodAdapter.class, (String)this.className, (String)methodName, (String)methodDescription);
        return methodAdapter;
    }
}

