/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.instrumentation.dependency;

import com.ikokoon.serenity.Collector;
import com.ikokoon.serenity.instrumentation.VisitorFactory;
import com.ikokoon.serenity.instrumentation.dependency.DependencyFieldAdapter;
import com.ikokoon.serenity.instrumentation.dependency.DependencyMethodAdapter;
import com.ikokoon.toolkit.Toolkit;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class DependencyClassAdapter
extends ClassAdapter
implements Opcodes {
    private Logger logger = Logger.getLogger(DependencyClassAdapter.class);
    private String className;
    private ByteArrayOutputStream source;

    public DependencyClassAdapter(ClassVisitor classVisitor, String className, ByteArrayOutputStream source) {
        super(classVisitor);
        this.className = Toolkit.slashToDot((String)className);
        this.source = source;
        this.logger.debug((Object)("Class name : " + className + ", source : " + source));
    }

    public void visit(int version, int access, String className, String signature, String superName, String[] interfaces) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visit : " + version + ", " + access + ", " + className + ", " + signature + ", " + superName));
            if (interfaces != null) {
                this.logger.debug((Object)Arrays.asList(interfaces).toString());
            }
        }
        String[] normedInterfaces = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            String normedInterface;
            normedInterfaces[i] = normedInterface = Toolkit.slashToDot((String)interfaces[i]);
        }
        Collector.collectEfferentAndAfferent((String)Toolkit.slashToDot((String)className), (String[])new String[]{Toolkit.slashToDot((String)superName)});
        Collector.collectEfferentAndAfferent((String)Toolkit.slashToDot((String)className), (String[])normedInterfaces);
        Collector.collectInterface((String)Toolkit.slashToDot((String)className), (Integer)access);
        super.visit(version, access, className, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitAnnotation : " + desc + ", " + visible));
        }
        AnnotationVisitor visitor = super.visitAnnotation(desc, visible);
        AnnotationVisitor adapter = VisitorFactory.getAnnotationVisitor((AnnotationVisitor)visitor, (String)this.className, (String)desc);
        return adapter;
    }

    public void visitAttribute(Attribute attr) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitAttribute : " + attr));
        }
        super.visitAttribute(attr);
    }

    public FieldVisitor visitField(int access, String fieldName, String desc, String signature, Object value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitField : " + access + ", " + fieldName + ", " + desc + ", " + signature + ", " + value));
        }
        FieldVisitor visitor = super.visitField(access, fieldName, desc, signature, value);
        FieldVisitor adapter = VisitorFactory.getFieldVisitor((FieldVisitor)visitor, DependencyFieldAdapter.class, (String)this.className, (String)desc, (String)signature);
        return adapter;
    }

    public void visitInnerClass(String innerName, String outerName, String innerSimpleName, int access) {
        if (this.logger.isDebugEnabled()) {
            this.logger.info((Object)("visitInnerClass : inner name : " + innerName + ", outer name : " + outerName + ", inner simple name : " + innerSimpleName));
        }
        if (outerName != null) {
            Collector.collectInnerClass((String)Toolkit.slashToDot((String)innerName), (String)Toolkit.slashToDot((String)outerName));
        }
        super.visitInnerClass(innerName, outerName, innerSimpleName, access);
    }

    public void visitOuterClass(String outerName, String outerMethodName, String outerMethodDescription) {
        if (this.logger.isDebugEnabled()) {
            this.logger.info((Object)("visitOuterClass : class name : " + this.className + ", owner : " + outerName + ", method name : " + outerMethodName + ", description : " + outerMethodDescription));
        }
        Collector.collectOuterClass((String)this.className, (String)Toolkit.slashToDot((String)outerName), (String)outerMethodName, (String)outerMethodDescription);
        super.visitOuterClass(outerName, outerMethodName, outerMethodDescription);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitMethod : " + access + ", " + name + ", " + desc + ", " + signature));
            if (exceptions != null) {
                this.logger.debug((Object)Arrays.asList(exceptions).toString());
            }
        }
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (exceptions != null) {
            for (String exception : exceptions) {
                Collector.collectEfferentAndAfferent((String)this.className, (String[])new String[]{Toolkit.slashToDot((String)exception)});
            }
        }
        MethodVisitor adapter = VisitorFactory.getMethodVisitor((MethodVisitor)visitor, DependencyMethodAdapter.class, (String)this.className, (String)name, (String)desc);
        return adapter;
    }

    public void visitSource(String source, String debug) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitSource : " + source + ", " + debug));
        }
        if (this.source != null && this.source.size() > 0) {
            Collector.collectSource((String)this.className, (String)this.source.toString());
        }
        super.visitSource(source, debug);
    }

    public void visitEnd() {
        this.logger.debug((Object)"visitEnd : ");
        super.visitEnd();
    }
}

