/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.instrumentation.dependency;

import com.ikokoon.serenity.Collector;
import com.ikokoon.serenity.instrumentation.VisitorFactory;
import com.ikokoon.toolkit.Toolkit;
import org.apache.log4j.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class DependencyMethodAdapter
extends MethodAdapter
implements Opcodes {
    private Logger logger = Logger.getLogger(this.getClass());
    private String className;
    private String methodName;
    private String methodDescription;

    public DependencyMethodAdapter(MethodVisitor methodVisitor, String className, String methodName, String methodDescription) {
        super(methodVisitor);
        Type[] argumentTypes;
        this.className = Toolkit.slashToDot((String)className);
        this.methodName = methodName;
        this.methodDescription = methodDescription;
        for (Type argumentType : argumentTypes = Type.getArgumentTypes((String)methodDescription)) {
            if (argumentType.getSort() == 10) {
                Collector.collectEfferentAndAfferent((String)className, (String[])new String[]{argumentType.getClassName()});
            }
            if (argumentType.getSort() != 9) continue;
            this.visitArray(argumentType);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Class name : " + className + ", name : " + methodName + ", desc : " + methodDescription));
        }
    }

    private void visitArray(Type argumentType) {
        if (argumentType.getSort() == 10) {
            Collector.collectEfferentAndAfferent((String)this.className, (String[])new String[]{argumentType.getClassName()});
        }
        if (argumentType.getSort() == 9) {
            argumentType = argumentType.getElementType();
            this.visitArray(argumentType);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.logger.debug((Object)("visitAnnotation : " + desc + ", " + visible));
        VisitorFactory.getSignatureVisitor((String)this.className, (String)desc);
        return this.mv.visitAnnotation(desc, visible);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitFieldInst : " + owner + ", " + name + ", " + desc));
        }
        VisitorFactory.getSignatureVisitor((String)this.className, (String)desc);
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitLineNumber(int lineNumber, Label label) {
        if (this.logger.isDebugEnabled()) {
            this.logger.info((Object)("visitLineNumber : " + this.className + ", " + lineNumber + ", " + label + ", " + label.getOffset() + ", " + this.className + ", " + this.methodName));
        }
        Collector.collectLines((String)this.className, (String)this.methodName, (String)this.methodDescription, (Integer)lineNumber);
        this.mv.visitLineNumber(lineNumber, label);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitLocalVariable : " + name + ", " + desc + ", " + signature + ", " + start + ", " + end + ", " + index));
        }
        VisitorFactory.getSignatureVisitor((String)this.className, (String)desc);
        if (signature != null) {
            VisitorFactory.getSignatureVisitor((String)this.className, (String)signature);
        }
        this.mv.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitMethodInst : " + opcode + ", " + owner + ", " + name + ", " + desc));
        }
        VisitorFactory.getSignatureVisitor((String)this.className, (String)desc);
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitMultiANewArrayInst : " + desc + ", " + dims));
        }
        VisitorFactory.getSignatureVisitor((String)this.className, (String)desc);
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitParameterAnnotation : " + parameter + ", " + desc + ", " + visible));
        }
        VisitorFactory.getSignatureVisitor((String)this.className, (String)desc);
        return this.mv.visitParameterAnnotation(parameter, desc, visible);
    }
}

