/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.persistence;

import com.ikokoon.serenity.model.Composite;
import com.ikokoon.serenity.persistence.DataBase;
import com.ikokoon.serenity.persistence.DataBaseOdb;
import com.ikokoon.serenity.persistence.IDataBaseEvent;
import com.ikokoon.serenity.persistence.IDataBaseListener;
import com.ikokoon.toolkit.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBFactory;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.criteria.Where;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBaseOdb
extends DataBase {
    private Logger logger = Logger.getLogger(this.getClass());
    private ODB odb = null;
    private IDataBaseListener dataBaseListener;
    private String dataBaseFile;
    private boolean closed = true;

    DataBaseOdb(IDataBaseListener dataBaseListener, String dataBaseFile, Boolean create) {
        this.dataBaseListener = dataBaseListener;
        this.dataBaseFile = dataBaseFile;
        this.logger.info((Object)("Opening ODB database on file : " + dataBaseFile));
        try {
            if (create.booleanValue()) {
                File file = new File(this.dataBaseFile);
                if (!file.delete()) {
                    this.logger.warn((Object)"Couldn't delete old database file");
                }
                this.logger.info((Object)("Database file : " + file.getAbsolutePath()));
            }
            this.odb = ODBFactory.open((String)this.dataBaseFile);
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception initialising the database", (Throwable)e);
        }
        this.closed = false;
        this.commit();
    }

    public synchronized <E extends Composite<?, ?>> E find(Class<E> klass, Long id) {
        CriteriaQuery query = new CriteriaQuery(klass, Where.equal((String)"id", (Object)id));
        return (E)this.find((IQuery)query);
    }

    public synchronized <E extends Composite<?, ?>> E find(Class<E> klass, List<Object> parameters) {
        Long id = Toolkit.hash((Object[])parameters.toArray());
        return (E)this.find(klass, id);
    }

    public synchronized <E extends Composite<?, ?>> List<E> find(Class<E> klass) {
        ArrayList<Composite> list = new ArrayList<Composite>();
        try {
            Objects objects = this.odb.getObjects(klass);
            while (objects.hasNext()) {
                list.add((Composite)objects.next());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception selecting objects with class : " + klass), (Throwable)e);
        }
        return list;
    }

    public <E extends Composite<?, ?>> List<E> find(Class<E> klass, Map<String, Object> parameters) {
        TreeSet set = new TreeSet();
        for (String field : parameters.keySet()) {
            Object value = parameters.get(field);
            this.logger.warn((Object)("Field : " + field + ", " + value));
            CriteriaQuery query = new CriteriaQuery(klass, Where.like((String)field, (String)("%" + value.toString() + "%")));
            try {
                Objects objects = this.odb.getObjects((IQuery)query);
                this.logger.warn((Object)("Objects : " + objects));
                if (set.size() == 0) {
                    set.addAll(objects);
                }
                set.retainAll((Collection<?>)objects);
                this.logger.warn((Object)("Set : " + set));
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception selecting objects with class : " + klass + ", parameters : " + parameters), (Throwable)e);
            }
        }
        ArrayList list = new ArrayList();
        list.addAll(set);
        this.logger.warn((Object)("List : " + list));
        return list;
    }

    private synchronized void commit() {
        try {
            this.odb.commit();
        }
        catch (IOException e) {
            this.logger.error((Object)"Exception comitting the ODB database", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception comitting the ODB database", (Throwable)e);
        }
    }

    public synchronized <E extends Composite<?, ?>> E persist(E composite) {
        try {
            this.setIds(composite);
            Composite duplicate = this.find(composite.getClass(), composite.getId());
            if (duplicate != null) {
                this.logger.warn((Object)("Attempted to persist a duplicate composite : " + composite));
                return composite;
            }
            this.logger.debug((Object)("Persisting composite : " + composite));
            this.odb.store(composite);
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception persisting object : " + composite), (Throwable)e);
        }
        this.commit();
        return composite;
    }

    public synchronized <E extends Composite<?, ?>> E remove(Class<E> klass, Long id) {
        Composite composite = this.find(klass, id);
        try {
            if (composite != null) {
                this.odb.delete((Object)composite);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception deleting object : " + id), (Throwable)e);
        }
        this.commit();
        return (E)composite;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() {
        try {
            if (this.closed) {
                this.logger.warn((Object)"Attempted to close the database again");
                return;
            }
            this.commit();
            this.odb.close();
            DataBaseOdb dataBase = this;
            1 dataBaseEvent = new /* Unavailable Anonymous Inner Class!! */;
            this.dataBaseListener.fireDataBaseEvent((IDataBaseEvent)dataBaseEvent);
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception closing the ODB database", (Throwable)e);
        }
        this.closed = true;
    }

    private synchronized <E extends Composite<?, ?>> E find(IQuery query) {
        Composite e = null;
        try {
            Objects objects = this.odb.getObjects(query);
            if (objects.size() == 1) {
                e = (Composite)objects.getFirst();
            } else if (objects.size() > 1) {
                this.logger.warn((Object)("Id for object must be unique : " + query));
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Exception selecting object on ODB database : " + query), (Throwable)ex);
        }
        return (E)e;
    }

    final synchronized void setIds(Composite<?, ?> composite) {
        if (composite == null) {
            return;
        }
        super.setId(composite);
        this.logger.debug((Object)("Persisted object : " + composite));
        List children = composite.getChildren();
        if (children != null) {
            for (Composite child : children) {
                this.setIds(child);
            }
        }
    }
}

