/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.persistence;

import com.ikokoon.serenity.LoggingConfigurator;
import com.ikokoon.serenity.model.Afferent;
import com.ikokoon.serenity.model.Class;
import com.ikokoon.serenity.model.Composite;
import com.ikokoon.serenity.model.Efferent;
import com.ikokoon.serenity.model.Line;
import com.ikokoon.serenity.model.Method;
import com.ikokoon.serenity.model.Package;
import com.ikokoon.serenity.model.Project;
import com.ikokoon.serenity.persistence.DataBaseOdb;
import com.ikokoon.serenity.persistence.DataBaseToolkit;
import com.ikokoon.serenity.persistence.IDataBase;
import com.ikokoon.toolkit.Toolkit;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DataBaseToolkit {
    private static Logger logger;

    public static void clear(IDataBase dataBase) {
        Project project = (Project)dataBase.find(Project.class, Toolkit.hash((String)Project.class.getName()));
        if (project != null) {
            dataBase.remove(Project.class, project.getId());
        }
        List packages = dataBase.find(Package.class);
        for (Package composite : packages) {
            dataBase.remove(composite.getClass(), composite.getId());
        }
        List classes = dataBase.find(Class.class);
        for (Class composite : classes) {
            dataBase.remove(composite.getClass(), composite.getId());
        }
        List methods = dataBase.find(Method.class);
        for (Method composite : methods) {
            dataBase.remove(composite.getClass(), composite.getId());
        }
        List lines = dataBase.find(Line.class);
        for (Line composite : lines) {
            dataBase.remove(composite.getClass(), composite.getId());
        }
    }

    public static void dump(IDataBase dataBase, ICriteria criteria, String message) {
        if (message != null) {
            logger.warn((Object)message);
        }
        try {
            Composite object = dataBase.find(Project.class, Toolkit.hash((String)Project.class.getName()));
            logger.info((Object)object);
            Project project = (Project)dataBase.find(Project.class, Toolkit.hash((String)Project.class.getName()));
            if (project != null) {
                logger.warn((Object)("Project : " + project.getName()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception dumping the data for the project object.", (Throwable)e);
        }
        try {
            List packages = dataBase.find(Package.class);
            for (Package pakkage : packages) {
                DataBaseToolkit.log((ICriteria)criteria, (Composite)pakkage, (int)1, (String)(pakkage.getId() + " : " + pakkage.getName() + ", coverage : " + pakkage.getCoverage() + ", complexity : " + pakkage.getComplexity() + ", stability : " + pakkage.getStability()));
                for (Class klass : pakkage.getChildren()) {
                    DataBaseToolkit.log((ICriteria)criteria, (Composite)klass, (int)2, (String)(" : id : " + klass.getId() + " : name : " + klass.getName() + " : coverage : " + klass.getCoverage() + ", complexity : " + klass.getComplexity() + ", outer class : " + klass.getOuterClass() + ", outer method : " + klass.getOuterMethod() + ", lines : " + klass.getChildren().size() + ", inner classes : " + klass.getInnerClasses()));
                    List efferents = klass.getEfferent();
                    List afferents = klass.getAfferent();
                    for (Efferent efferent : efferents) {
                        DataBaseToolkit.log((ICriteria)criteria, (Composite)efferent, (int)4, (String)efferent.getName());
                    }
                    for (Afferent afferent : afferents) {
                        DataBaseToolkit.log((ICriteria)criteria, (Composite)afferent, (int)4, (String)afferent.getName());
                    }
                    for (Method method : klass.getChildren()) {
                        DataBaseToolkit.log((ICriteria)criteria, (Composite)method, (int)3, (String)(method.getId() + " : name : " + method.getName() + " : coverage : " + method.getCoverage() + ", complexity : " + method.getComplexity()));
                        for (Line line : method.getChildren()) {
                            DataBaseToolkit.log((ICriteria)criteria, (Composite)line, (int)4, (String)(line.getId() + " : number : " + line.getNumber() + ", counter : " + line.getCounter()));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception dumping the data for the database.", (Throwable)e);
        }
    }

    private static void log(ICriteria criteria, Composite<?, ?> composite, int tabs, String data) {
        if (criteria == null || criteria != null && criteria.satisfied(composite)) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < tabs; ++i) {
                builder.append("\t");
            }
            builder.append(composite.getClass().getSimpleName());
            builder.append(" : ");
            builder.append(data);
            logger.warn((Object)builder.toString());
        }
    }

    public static void main(String[] args) {
        IDataBase dataBase = IDataBase.DataBaseManager.getDataBase(DataBaseOdb.class, (String)"C:/Eclipse/workspace/Discovery/serenity/serenity.odb", (boolean)false, null);
        DataBaseToolkit.dump((IDataBase)dataBase, (ICriteria)new /* Unavailable Anonymous Inner Class!! */, (String)"Data base toolkit dump : ");
        Project project = (Project)dataBase.find(Project.class, Toolkit.hash((String)Project.class.getName()));
        logger.info((Object)("Project : " + project.getCoverage()));
        dataBase.close();
    }

    static {
        LoggingConfigurator.configure();
        logger = Logger.getLogger(DataBaseToolkit.class);
    }
}

