/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.process;

import com.ikokoon.serenity.Configuration;
import com.ikokoon.serenity.instrumentation.VisitorFactory;
import com.ikokoon.serenity.process.AProcess;
import com.ikokoon.serenity.process.IProcess;
import com.ikokoon.toolkit.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.objectweb.asm.ClassVisitor;

public class Accumulator
extends AProcess {
    private Set<String> jarsProcessed = new TreeSet();
    private Set<String> filesProcessed = new TreeSet();
    private Class<ClassVisitor>[] CLASS_ADAPTER_CLASSES;

    public Accumulator(IProcess parent) {
        super(parent);
        this.CLASS_ADAPTER_CLASSES = Configuration.getConfiguration().classAdapters.toArray(new Class[Configuration.getConfiguration().classAdapters.size()]);
    }

    public void execute() {
        super.execute();
        String classpath = Configuration.getConfiguration().getClassPath();
        StringTokenizer stringTokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            File file = new File(token);
            this.logger.debug((Object)("Processing jar : " + token + ", file : " + file.getAbsolutePath()));
            if (!file.exists() || !file.canRead()) {
                this.logger.warn((Object)("Can't read file : " + file.getAbsolutePath()));
                continue;
            }
            if (file.isFile()) {
                if (!token.endsWith(".jar") && !token.endsWith(".zip") && !token.endsWith(".war") && !token.endsWith(".ear")) continue;
                this.logger.debug((Object)("Processing jar : " + file.getAbsolutePath()));
                this.processJar(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.processDir(file);
        }
        ArrayList list = new ArrayList();
        File baseDirectory = new File(".");
        this.logger.info((Object)("Looking for source in base directory : " + baseDirectory.getAbsolutePath()));
        Toolkit.findFiles((File)baseDirectory, (Toolkit.IFileFilter)new /* Unavailable Anonymous Inner Class!! */, list);
        for (File file : list) {
            this.logger.debug((Object)("Processing jar : " + file.getAbsolutePath()));
            this.processJar(file);
        }
    }

    void processDir(File file) {
        if (file == null || !file.exists() || !file.canWrite()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int j = 0; j < files.length; ++j) {
                file = files[j];
                this.processDir(file);
            }
        } else if (file.isFile() && file.canRead()) {
            String filePath = file.getAbsolutePath();
            if (this.excluded(filePath = Toolkit.slashToDot((String)filePath))) {
                return;
            }
            byte[] classBytes = Toolkit.getContents((File)file).toByteArray();
            ByteArrayOutputStream source = new ByteArrayOutputStream();
            String className = null;
            for (String packageName : Configuration.getConfiguration().includedPackages) {
                if (filePath.indexOf(packageName) <= -1) continue;
                int indexOfPackageName = filePath.indexOf(packageName);
                int classIndex = filePath.lastIndexOf(".class");
                try {
                    if (classIndex <= -1) continue;
                    className = filePath.substring(indexOfPackageName, classIndex);
                    break;
                }
                catch (Exception e) {
                    this.logger.error((Object)"Exception reading the class files in a directory", (Throwable)e);
                }
            }
            if (!this.filesProcessed.add(className)) {
                return;
            }
            this.processClass(className, classBytes, source);
        }
    }

    private void processJar(File file) {
        if (!this.jarsProcessed.add(file.getName())) {
            return;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
        }
        catch (Exception e) {
            this.logger.error((Object)("Exeption accessing the jar : " + file), (Throwable)e);
            return;
        }
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String entryName = jarEntry.getName();
            if (this.excluded(Toolkit.slashToDot((String)entryName))) continue;
            try {
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] classFileBytes = Toolkit.getContents((InputStream)inputStream).toByteArray();
                ByteArrayOutputStream source = null;
                source = jarEntry.getName().indexOf("$") == -1 ? this.getSource(jarFile, entryName) : new ByteArrayOutputStream();
                this.processClass(Toolkit.slashToDot((String)entryName), classFileBytes, source);
            }
            catch (IOException e) {
                this.logger.error((Object)("Exception reading entry : " + jarEntry + ", from file : " + jarFile), (Throwable)e);
            }
        }
    }

    private ByteArrayOutputStream getSource(JarFile jarFile, String entryName) throws IOException {
        String javaEntryName = entryName.substring(0, entryName.lastIndexOf(46)) + ".java";
        ZipEntry javaEntry = jarFile.getEntry(javaEntryName);
        if (javaEntry != null) {
            InputStream inputStream = jarFile.getInputStream(javaEntry);
            return Toolkit.getContents((InputStream)inputStream);
        }
        return new ByteArrayOutputStream();
    }

    private void processClass(String name, byte[] classBytes, ByteArrayOutputStream source) {
        if (name != null && name.endsWith(".class")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        try {
            VisitorFactory.getClassVisitor((Class[])this.CLASS_ADAPTER_CLASSES, (String)name, (byte[])classBytes, (ByteArrayOutputStream)source);
        }
        catch (Exception e) {
            int sourceLength = source != null ? source.size() : 0;
            this.logger.warn((Object)("Class name : " + name + ", length : " + classBytes.length + ", source : " + sourceLength));
            this.logger.error((Object)("Exception accululating data on class " + name), (Throwable)e);
        }
    }

    private boolean excluded(String name) {
        if (!name.endsWith(".class")) {
            this.logger.debug((Object)("Not processing file : " + name));
            return true;
        }
        if (!Configuration.getConfiguration().included(name)) {
            this.logger.debug((Object)("File not included : " + name));
            return true;
        }
        if (Configuration.getConfiguration().excluded(name)) {
            this.logger.debug((Object)("Excluded file : " + name));
            return true;
        }
        if (!this.filesProcessed.add(name)) {
            this.logger.debug((Object)("Already done file : " + name));
            return true;
        }
        return false;
    }
}

