/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.process;

import com.ikokoon.serenity.IConstants;
import com.ikokoon.serenity.model.Afferent;
import com.ikokoon.serenity.model.Class;
import com.ikokoon.serenity.model.Composite;
import com.ikokoon.serenity.model.Efferent;
import com.ikokoon.serenity.model.Line;
import com.ikokoon.serenity.model.Method;
import com.ikokoon.serenity.model.Package;
import com.ikokoon.serenity.model.Project;
import com.ikokoon.serenity.persistence.IDataBase;
import com.ikokoon.serenity.process.AProcess;
import com.ikokoon.serenity.process.IProcess;
import com.ikokoon.toolkit.Toolkit;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregator
extends AProcess
implements IConstants {
    private static final int PRECISION = 2;
    private IDataBase dataBase;
    private Map<Composite<?, ?>, Set<Line<?, ?>>> compositeLines;
    private Map<Composite<?, ?>, Set<Method<?, ?>>> compositeMethods;

    public Aggregator(IProcess parent, IDataBase dataBase) {
        super(parent);
        this.dataBase = dataBase;
        this.compositeLines = new HashMap();
        this.compositeMethods = new HashMap();
        Project project = (Project)dataBase.find(Project.class, Toolkit.hash((String)Project.class.getName()));
        if (project == null) {
            project = new Project();
            dataBase.persist((Composite)project);
        }
        List packages = dataBase.find(Package.class);
        Set lines = this.getLines((Collection)packages);
        Set methods = this.getMethods((Collection)packages);
        this.compositeLines.put(project, lines);
        this.compositeMethods.put(project, methods);
    }

    public void execute() {
        super.execute();
        this.logger.debug((Object)"Running Aggregator: ");
        Project project = (Project)this.dataBase.find(Project.class, Toolkit.hash((String)Project.class.getName()));
        this.aggregateProject(project);
    }

    protected void aggregateProject(Project<?, ?> project) {
        List packages = this.dataBase.find(Package.class);
        Set lines = (Set)this.compositeLines.get(project);
        Set methods = (Set)this.compositeMethods.get(project);
        this.aggregatePackages(packages);
        project.setTimestamp(new Date());
        double classes = 0.0;
        double totalComplexity = 0.0;
        double executed = 0.0;
        double interfaces = 0.0;
        double implementations = 0.0;
        TreeSet efference = new TreeSet();
        TreeSet afference = new TreeSet();
        for (Method method : methods) {
            totalComplexity += method.getComplexity();
        }
        for (Line line : lines) {
            if (!(line.getCounter() > 0.0)) continue;
            executed += 1.0;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Lines : " + lines.size() + ", executed : " + executed));
        }
        if (lines.size() > 0) {
            for (Package pakkage : packages) {
                interfaces += pakkage.getInterfaces();
                implementations += pakkage.getImplementations();
                efference.addAll(pakkage.getEfferent());
                afference.addAll(pakkage.getAfferent());
                classes += (double)pakkage.getChildren().size();
            }
        }
        double coverage = this.getCoverage((double)lines.size(), executed);
        double complexity = this.getComplexity((double)methods.size(), totalComplexity);
        double stability = this.getStability((double)efference.size(), (double)afference.size());
        double abstractness = this.getAbstractness(interfaces, implementations);
        double distance = this.getDistance(stability, abstractness);
        project.setComplexity(complexity);
        project.setCoverage(coverage);
        project.setAbstractness(abstractness);
        project.setStability(stability);
        project.setDistance(distance);
        project.setLines((double)lines.size());
        project.setMethods((double)methods.size());
        project.setClasses(classes);
        project.setPackages((double)packages.size());
        this.setPrecision(project);
    }

    private double getDistance(double stability, double abstractness) {
        double a = -1.0;
        double b = -1.0;
        double distance = Math.abs(-stability + -abstractness + 1.0) / Math.sqrt(Math.pow(a, 2.0) + Math.pow(b, 2.0));
        return distance;
    }

    private double getAbstractness(double interfaces, double implementations) {
        double abstractness = interfaces + implementations > 0.0 ? interfaces / (interfaces + implementations) : 1.0;
        return abstractness;
    }

    private double getStability(double efferent, double afferent) {
        double stability = efferent + afferent > 0.0 ? efferent / (efferent + afferent) : 1.0;
        return stability;
    }

    private double getComplexity(double methods, double totalComplexity) {
        double complexity = methods > 0.0 ? totalComplexity / methods : 0.0;
        return complexity;
    }

    private double getCoverage(double lines, double executed) {
        double coverage = lines > 0.0 ? executed / lines * 100.0 : 0.0;
        return coverage;
    }

    protected void aggregatePackages(List<Package> children) {
        for (Package pakkage : children) {
            List classes = pakkage.getChildren();
            this.aggregateClasses(classes);
            this.aggregatePackage(pakkage);
            this.setPrecision((Composite)pakkage);
        }
    }

    protected void aggregatePackage(Package<?, ?> pakkage) {
        Set lines = (Set)this.compositeLines.get(pakkage);
        Set methods = (Set)this.compositeMethods.get(pakkage);
        double interfaces = 0.0;
        double implementations = 0.0;
        double executed = 0.0;
        double methodAccumulatedComplexity = 0.0;
        for (Line line : lines) {
            if (!(line.getCounter() > 0.0)) continue;
            executed += 1.0;
        }
        for (Method method : methods) {
            methodAccumulatedComplexity += method.getComplexity();
        }
        TreeSet<Efferent> efference = new TreeSet<Efferent>();
        TreeSet<Afferent> afference = new TreeSet<Afferent>();
        for (Class klass : pakkage.getChildren()) {
            if (klass.getInterfaze()) {
                interfaces += 1.0;
            } else {
                implementations += 1.0;
            }
            for (Efferent efferent : klass.getEfferent()) {
                efference.add(efferent);
            }
            for (Afferent afferent : klass.getAfferent()) {
                afference.add(afferent);
            }
        }
        pakkage.setEfferent(efference);
        pakkage.setAfferent(afference);
        pakkage.setLines((double)lines.size());
        pakkage.setExecuted(executed);
        double coverage = this.getCoverage((double)lines.size(), executed);
        double complexity = this.getComplexity((double)methods.size(), methodAccumulatedComplexity);
        double abstractness = this.getAbstractness(interfaces, implementations);
        double stability = this.getStability((double)efference.size(), (double)afference.size());
        double distance = this.getDistance(stability, abstractness);
        pakkage.setInterfaces(interfaces);
        pakkage.setImplementations(implementations);
        pakkage.setEfference((double)efference.size());
        pakkage.setAfference((double)afference.size());
        pakkage.setCoverage(coverage);
        pakkage.setComplexity(complexity);
        pakkage.setStability(stability);
        pakkage.setAbstractness(abstractness);
        pakkage.setDistance(distance);
    }

    protected void aggregateClasses(List<Class<?, ?>> classes) {
        for (Class<?, ?> klass : classes) {
            List methods = klass.getChildren();
            this.aggregateMethods(methods);
            this.aggregateClass(klass);
            this.setPrecision(klass);
        }
    }

    protected void aggregateClass(Class<?, ?> klass) {
        Set lines = (Set)this.compositeLines.get(klass);
        Set methods = (Set)this.compositeMethods.get(klass);
        double executed = 0.0;
        double totalComplexity = 0.0;
        for (Line line : lines) {
            if (!(line.getCounter() > 0.0)) continue;
            executed += 1.0;
        }
        for (Method method : methods) {
            if (lines.size() > 0) {
                totalComplexity += method.getComplexity();
                continue;
            }
            totalComplexity += 1.0;
        }
        double coverage = this.getCoverage((double)lines.size(), executed);
        double complexity = this.getComplexity((double)methods.size(), totalComplexity);
        klass.setCoverage(coverage);
        klass.setComplexity(complexity);
        klass.setAfference((double)klass.getAfferent().size());
        klass.setEfference((double)klass.getEfferent().size());
        double stability = this.getStability((double)klass.getEfferent().size(), (double)klass.getAfferent().size());
        klass.setStability(stability);
    }

    protected Set<Line<?, ?>> getLines(Collection<Package> pakkages) {
        TreeSet projectLines = new TreeSet();
        for (Package pakkage : pakkages) {
            Set lines = this.getLines(pakkage);
            this.compositeLines.put(pakkage, lines);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Package : " + pakkage + ", line size : " + lines.size()));
            }
            projectLines.addAll(lines);
        }
        return projectLines;
    }

    protected Set<Method<?, ?>> getMethods(Collection<Package> pakkages) {
        TreeSet projectMethods = new TreeSet();
        for (Package pakkage : pakkages) {
            Set methods = this.getMethods(pakkage);
            this.compositeMethods.put(pakkage, methods);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Package : " + pakkage + ", method size : " + methods.size()));
            }
            projectMethods.addAll(methods);
        }
        return projectMethods;
    }

    protected Set<Line<?, ?>> getLines(Package<?, ?> pakkage) {
        TreeSet packageLines = new TreeSet();
        for (Class klass : pakkage.getChildren()) {
            Set lines = this.getLines(klass, new TreeSet());
            this.compositeLines.put(klass, lines);
            packageLines.addAll(lines);
        }
        return packageLines;
    }

    protected Set<Method<?, ?>> getMethods(Package<?, ?> pakkage) {
        TreeSet packageMethods = new TreeSet();
        for (Class klass : pakkage.getChildren()) {
            TreeSet methods = new TreeSet();
            this.getMethods(klass, methods);
            this.compositeMethods.put(klass, methods);
            packageMethods.addAll(methods);
        }
        return packageMethods;
    }

    protected Set<Line<?, ?>> getLines(Class<?, ?> klass, Set<Line<?, ?>> lines) {
        for (Class innerKlass : klass.getInnerClasses()) {
            this.getLines(innerKlass, lines);
        }
        for (Method method : klass.getChildren()) {
            for (Line line : method.getChildren()) {
                if (this.containsLine(lines, line)) continue;
                lines.add(line);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info((Object)("Class : " + klass + ", line size : " + lines.size()));
        }
        return lines;
    }

    protected Set<Method<?, ?>> getMethods(Class<?, ?> klass, Set<Method<?, ?>> methods) {
        for (Class innerKlass : klass.getInnerClasses()) {
            this.getMethods(innerKlass, methods);
        }
        for (Method method : klass.getChildren()) {
            methods.add(method);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info((Object)("Class : " + klass + ", method size : " + methods.size()));
        }
        return methods;
    }

    private boolean containsLine(Set<Line<?, ?>> lines, Line<?, ?> line) {
        for (Line<?, ?> setLine : lines) {
            if (setLine.getNumber() != line.getNumber()) continue;
            return true;
        }
        return false;
    }

    protected void aggregateMethods(List<Method<?, ?>> methods) {
        for (Method<?, ?> method : methods) {
            try {
                double executed = 0.0;
                for (Line line : method.getChildren()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Line covered : " + line + ", " + line.getCounter()));
                    }
                    if (!(line.getCounter() > 0.0)) continue;
                    executed += 1.0;
                }
                if (method.getChildren().size() <= 0) continue;
                double coverage = this.getCoverage((double)method.getChildren().size(), executed);
                method.setCoverage(coverage);
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception peocessing the method element : " + method.getName()), (Throwable)e);
            }
        }
    }

    private void setPrecision(Composite<?, ?> composite) {
        Field[] fields;
        for (Field field : fields = composite.getClass().getDeclaredFields()) {
            if (!Double.TYPE.isAssignableFrom(field.getType()) && !Double.class.isAssignableFrom(field.getDeclaringClass())) continue;
            try {
                field.setAccessible(true);
                double value = field.getDouble(composite);
                value = Toolkit.format((double)value, (int)2);
                field.setDouble(composite, value);
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception accessing the field : " + field), (Throwable)e);
            }
        }
    }
}

