/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.toolkit;

import com.ikokoon.toolkit.Permutations;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class ObjectFactory {
    private static Logger LOGGER = Logger.getLogger(ObjectFactory.class);

    public static <E> E getObject(Class<E> klass, Object ... allParameters) {
        ArrayList parameters = new ArrayList();
        Constructor constructor = ObjectFactory.getConstructor(klass, (Object[])allParameters, parameters);
        if (constructor != null) {
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            try {
                return (E)constructor.newInstance(parameters.toArray());
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)("Exception generating the action for " + klass + ", with parameters : " + Arrays.asList(allParameters)), (Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error((Object)("Exception generating the action for " + klass + ", with parameters : " + Arrays.asList(allParameters)), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)("Exception generating the action for " + klass + ", with parameters : " + Arrays.asList(allParameters)), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error((Object)("Exception generating the action for " + klass + ", with parameters : " + Arrays.asList(allParameters)), (Throwable)e);
            }
        }
        return null;
    }

    protected static <E> Constructor<E> getConstructor(Class<E> klass, Object[] allParameters, List<Object> parameters) {
        Constructor constructor = ObjectFactory.getConstructor(klass, (Object[])allParameters);
        if (constructor != null) {
            parameters.addAll(Arrays.asList(allParameters));
            LOGGER.debug((Object)("Got constructor : " + constructor + ", with parameters : " + parameters));
            return constructor;
        }
        Permutations permutations = new Permutations();
        ArrayList permutationsList = new ArrayList();
        permutations.getPermutations(allParameters, permutationsList, allParameters.length);
        for (Object[] permutationParameters : permutationsList) {
            LOGGER.debug((Object)("Permutations : " + Arrays.asList(permutationParameters)));
            constructor = ObjectFactory.getConstructor(klass, (Object[])permutationParameters);
            if (constructor != null) {
                parameters.addAll(Arrays.asList(allParameters));
                LOGGER.debug((Object)("Got constructor : " + constructor + ", with parameters : " + parameters));
                return constructor;
            }
            for (int first = 0; first < permutationParameters.length; ++first) {
                for (int last = first; last < permutationParameters.length; ++last) {
                    int size = last - first;
                    LOGGER.debug((Object)("First : " + first + ", last : " + last + ", size : " + size));
                    Object[] dest = new Object[size];
                    System.arraycopy(permutationParameters, first, dest, 0, size);
                    constructor = ObjectFactory.getConstructor(klass, (Object[])dest);
                    if (constructor == null) continue;
                    parameters.addAll(Arrays.asList(dest));
                    LOGGER.debug((Object)("Got constructor : " + constructor + ", with parameters : " + parameters));
                    return constructor;
                }
            }
        }
        return null;
    }

    private static <E> Constructor<E> getConstructor(Class<E> klass, Object[] permutationParameters) {
        Constructor<?>[] constructors;
        LOGGER.debug((Object)("Stripped permutations : " + Arrays.asList(permutationParameters)));
        block0: for (Constructor<?> constructor : constructors = klass.getDeclaredConstructors()) {
            LOGGER.debug((Object)("Looking at constructor : " + constructor + " for class " + klass));
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes != null && parameterTypes.length != permutationParameters.length) continue;
            int index = -1;
            for (Class<?> parameterType : parameterTypes) {
                if (permutationParameters[++index] == null || !parameterType.isAssignableFrom(permutationParameters[index].getClass())) continue block0;
            }
            return constructor;
        }
        return null;
    }

    private ObjectFactory() {
    }
}

