function base64Encode(data) {
	if (typeof (btoa) == 'function')
		return btoa(data);
	var b64_map = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
	var byte1, byte2, byte3;
	var ch1, ch2, ch3, ch4;
	var result = new Array();
	var j = 0;
	for ( var i = 0; i < data.length; i += 3) {
		byte1 = data.charCodeAt(i);
		byte2 = data.charCodeAt(i + 1);
		byte3 = data.charCodeAt(i + 2);
		ch1 = byte1 >> 2;
		ch2 = ((byte1 & 3) << 4) | (byte2 >> 4);
		ch3 = ((byte2 & 15) << 2) | (byte3 >> 6);
		ch4 = byte3 & 63;
		if (isNaN(byte2)) {
			ch3 = ch4 = 64;
		} else if (isNaN(byte3)) {
			ch4 = 64;
		}
		result[j++] = b64_map.charAt(ch1) + b64_map.charAt(ch2)
				+ b64_map.charAt(ch3) + b64_map.charAt(ch4);
	}
	return result.join('');
}
function base64Decode(data) {
	data = data.replace(/[^a-z0-9\+\/=]/ig, '');
	// if (typeof (atob) == 'function')
	//  	return atob(data);
	var b64_map = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
	var byte1, byte2, byte3;
	var ch1, ch2, ch3, ch4;
	var result = new Array();
	var j = 0;
	while ((data.length % 4) != 0) {
		data += '=';
	}
	for ( var i = 0; i < data.length; i += 4) {
		ch1 = b64_map.indexOf(data.charAt(i));
		ch2 = b64_map.indexOf(data.charAt(i + 1));
		ch3 = b64_map.indexOf(data.charAt(i + 2));
		ch4 = b64_map.indexOf(data.charAt(i + 3));
		byte1 = (ch1 << 2) | (ch2 >> 4);
		byte2 = ((ch2 & 15) << 4) | (ch3 >> 2);
		byte3 = ((ch3 & 3) << 6) | ch4;
		result[j++] = String.fromCharCode(byte1);
		if (ch3 != 64)
			result[j++] = String.fromCharCode(byte2);
		if (ch4 != 64)
			result[j++] = String.fromCharCode(byte3);
	}
	return result.join('');
}