/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.hudson;

import com.ikokoon.serenity.hudson.ISerenityResult;
import com.ikokoon.serenity.hudson.SerenityBuildAction;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class SerenityProjectAction
extends Actionable
implements ProminentProjectAction {
    private Logger logger = Logger.getLogger(SerenityProjectAction.class);
    private AbstractProject owner;

    public SerenityProjectAction(AbstractProject owner) {
        this.logger.debug((Object)"SerenityProjectAction:");
        this.owner = owner;
    }

    public String getDisplayName() {
        this.logger.debug((Object)"getDisplayName");
        return "Serenity report";
    }

    public String getIconFileName() {
        this.logger.debug((Object)"getIconFileName");
        return "graph.gif";
    }

    public String getUrlName() {
        this.logger.debug((Object)"getUrlName");
        return "serenity";
    }

    public String getSearchUrl() {
        this.logger.debug((Object)"getSearchUrl");
        return this.getUrlName();
    }

    public ISerenityResult getLastResult() {
        SerenityBuildAction action;
        this.logger.debug((Object)"getLastResult");
        Run build = this.owner.getLastStableBuild();
        if (build == null) {
            build = this.owner.getLastBuild();
        }
        if (build != null && (action = (SerenityBuildAction)build.getAction(SerenityBuildAction.class)) != null) {
            return action.getResult();
        }
        return null;
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.logger.debug((Object)"doIndex");
        if (this.hasResult()) {
            rsp.sendRedirect2("../lastBuild/serenity");
        } else {
            rsp.sendRedirect2("nocoverage");
        }
    }

    public boolean hasResult() {
        this.logger.debug((Object)"hasResult");
        return this.getLastResult() != null;
    }
}

