/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.hudson;

import com.ikokoon.serenity.LoggingConfigurator;
import com.ikokoon.serenity.hudson.ISerenityResult;
import com.ikokoon.serenity.hudson.SerenityBuildAction;
import com.ikokoon.serenity.hudson.SerenityProjectAction;
import com.ikokoon.serenity.hudson.SerenityPublisher;
import com.ikokoon.serenity.hudson.SerenityResult;
import com.ikokoon.toolkit.Toolkit;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerenityPublisher
extends Recorder {
    protected static Logger logger;
    public static final DescriptorImpl DESCRIPTOR;

    @DataBoundConstructor
    public SerenityPublisher() {
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener buildListener) throws InterruptedException, IOException {
        logger.debug((Object)"perform");
        if (!Result.SUCCESS.equals(build.getResult())) {
            buildListener.getLogger().println("Build was not successful... but will still try to publish the report");
        }
        buildListener.getLogger().println("Publishing Serenity reports...");
        this.copyDataBaseToBuildDirectory(build, buildListener);
        this.copySourceToBuildDirectory(build, buildListener);
        buildListener.getLogger().println("Accessing Serenity results...");
        SerenityResult result = new SerenityResult(build);
        SerenityBuildAction buildAction = new SerenityBuildAction(build, (ISerenityResult)result);
        build.getActions().add(buildAction);
        return true;
    }

    private boolean copySourceToBuildDirectory(AbstractBuild<?, ?> build, BuildListener buildListener) throws InterruptedException, IOException {
        FilePath moduleRoot = build.getWorkspace();
        buildListener.getLogger().println("Module root : " + moduleRoot.toURI().getRawPath());
        ArrayList sourceDirectories = new ArrayList();
        Toolkit.findFiles((File)new File(moduleRoot.toURI().getRawPath()), (Toolkit.IFileFilter)new /* Unavailable Anonymous Inner Class!! */, sourceDirectories);
        FilePath buildDirectory = new FilePath(build.getRootDir());
        FilePath buildSourceDirectory = new FilePath(buildDirectory, "./serenity/source");
        File targetSourceDirectory = new File(buildSourceDirectory.toURI().getRawPath());
        try {
            for (File sourceDirectory : sourceDirectories) {
                buildListener.getLogger().println("Publishing serenity source from : " + sourceDirectory.getAbsolutePath() + ", to : " + buildSourceDirectory.toURI().getRawPath());
                Toolkit.copyFile((File)sourceDirectory, (File)targetSourceDirectory);
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)buildListener);
            e.printStackTrace(buildListener.fatalError("Unable to copy Serenity database file from : " + sourceDirectories + ", to : " + buildDirectory));
        }
        return true;
    }

    private boolean copyDataBaseToBuildDirectory(AbstractBuild<?, ?> build, BuildListener buildListener) throws InterruptedException, IOException {
        String serenityDatabase = "**/serenity/serenity.odb";
        FilePath[] reports = new FilePath[]{};
        FilePath moduleRoot = build.getWorkspace();
        buildListener.getLogger().println("Module root : " + moduleRoot.toURI().getRawPath());
        try {
            reports = moduleRoot.list(serenityDatabase);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)buildListener);
            e.printStackTrace(buildListener.fatalError("Unable to find Serenity results"));
            build.setResult(Result.FAILURE);
            return false;
        }
        if (reports.length == 0) {
            buildListener.getLogger().println("No coverage results were found using the pattern '" + serenityDatabase + "'.");
            build.setResult(Result.FAILURE);
            return true;
        }
        if (reports.length > 1) {
            buildListener.getLogger().println("Serenity publisher found more than one report that match the pattern. Impossible, but true.");
            build.setResult(Result.FAILURE);
            return true;
        }
        FilePath buildTarget = new FilePath(build.getRootDir());
        FilePath singleReport = reports[0];
        FilePath targetPath = new FilePath(buildTarget, "./serenity/serenity.odb");
        try {
            buildListener.getLogger().println("Publishing serenity db from : " + singleReport.toURI().getRawPath() + ", to : " + targetPath.toURI().getRawPath());
            singleReport.copyTo(targetPath);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)buildListener);
            e.printStackTrace(buildListener.fatalError("Unable to copy Serenity database file from : " + singleReport + ", to : " + buildTarget));
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    public Action getProjectAction(AbstractProject abstractProject) {
        logger.debug((Object)"getProjectAction(AbstractProject)");
        return new SerenityProjectAction(abstractProject);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        logger.debug((Object)"getRequiredMonitorService");
        return BuildStepMonitor.STEP;
    }

    static {
        LoggingConfigurator.configure();
        logger = Logger.getLogger(SerenityPublisher.class);
        DESCRIPTOR = new DescriptorImpl();
    }
}

