/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.hudson;

import com.ikokoon.serenity.hudson.ISerenityResult;
import com.ikokoon.serenity.hudson.modeller.HighchartsModeller;
import com.ikokoon.serenity.model.Composite;
import com.ikokoon.serenity.model.Package;
import com.ikokoon.serenity.persistence.DataBaseOdb;
import com.ikokoon.serenity.persistence.IDataBase;
import com.ikokoon.toolkit.Toolkit;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Project;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerenityResult
implements ISerenityResult {
    private Logger logger = Logger.getLogger(SerenityResult.class);
    private AbstractBuild<?, ?> abstractBuild;
    private com.ikokoon.serenity.model.Project<?, ?> project;
    private Composite<?, ?> composite;

    public SerenityResult(AbstractBuild<?, ?> abstractBuild) {
        this.logger.debug((Object)"SerenityResult");
        this.abstractBuild = abstractBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws Exception {
        IDataBase dataBase;
        block5: {
            long _id;
            String id;
            String klass;
            block6: {
                this.logger.debug((Object)("getDynamic:" + token));
                klass = req.getParameter("class");
                id = req.getParameter("id");
                dataBase = null;
                if (klass == null || id == null) break block5;
                _id = Long.parseLong(id);
                if (this.composite == null || !this.composite.getId().equals(_id)) break block6;
                SerenityResult serenityResult = this;
                this.closeDataBase(dataBase);
                return serenityResult;
            }
            try {
                Class<?> _klass = Class.forName(klass);
                dataBase = this.getDataBase(this.abstractBuild);
                this.composite = dataBase.find(_klass, Long.valueOf(_id));
                this.logger.debug((Object)("Class : " + klass + ", id : " + id + ", " + this.composite));
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)("Exception initialising the model and the source for : " + klass + ", " + id), (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.closeDataBase(dataBase);
                    throw throwable;
                }
                this.closeDataBase(dataBase);
            }
        }
        this.closeDataBase(dataBase);
        return this;
    }

    public Object getOwner() {
        this.logger.debug((Object)"getOwner");
        return this.abstractBuild;
    }

    public String getName() {
        AbstractProject abstractProject;
        this.logger.debug((Object)"getName");
        if (this.abstractBuild != null && (abstractProject = this.abstractBuild.getProject()) != null) {
            return abstractProject.getName();
        }
        return "No name Project...";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasReport() {
        this.logger.debug((Object)"hasReport");
        IDataBase dataBase = null;
        try {
            dataBase = this.getDataBase(this.abstractBuild);
            boolean bl = dataBase.find(com.ikokoon.serenity.model.Project.class, Toolkit.hash((String)com.ikokoon.serenity.model.Project.class.getName())) != null;
            return bl;
        }
        finally {
            this.closeDataBase(dataBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.ikokoon.serenity.model.Project<?, ?> getProject() {
        this.logger.debug((Object)"getProject");
        if (this.project == null) {
            IDataBase dataBase = null;
            try {
                dataBase = this.getDataBase(this.abstractBuild);
                this.project = (com.ikokoon.serenity.model.Project)dataBase.find(com.ikokoon.serenity.model.Project.class, Toolkit.hash((String)com.ikokoon.serenity.model.Project.class.getName()));
            }
            finally {
                this.closeDataBase(dataBase);
            }
        }
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Package> getPackages() {
        this.logger.debug((Object)"getPackages");
        IDataBase dataBase = null;
        try {
            dataBase = this.getDataBase(this.abstractBuild);
            List packages = dataBase.find(Package.class);
            if (packages != null) {
                Collections.sort(packages, new /* Unavailable Anonymous Inner Class!! */);
                for (Package pakkage : packages) {
                    Collections.sort(pakkage.getChildren(), new /* Unavailable Anonymous Inner Class!! */);
                    for (com.ikokoon.serenity.model.Class klass : pakkage.getChildren()) {
                        Collections.sort(klass.getChildren(), new /* Unavailable Anonymous Inner Class!! */);
                    }
                }
            }
            for (Package pakkage : packages) {
                Iterator iterator = pakkage.getChildren().iterator();
                while (iterator.hasNext()) {
                    com.ikokoon.serenity.model.Class klass;
                    klass = (com.ikokoon.serenity.model.Class)iterator.next();
                    if (klass.getName().indexOf("$") <= -1) continue;
                    iterator.remove();
                }
            }
            List list = packages;
            return list;
        }
        finally {
            this.closeDataBase(dataBase);
        }
    }

    public String getModel() {
        this.logger.debug((Object)"getModel");
        if (this.composite == null) {
            return "";
        }
        return this.getModel(null, this.composite);
    }

    public String getProjectModel() {
        IDataBase dataBase = this.getDataBase(this.abstractBuild);
        com.ikokoon.serenity.model.Project project = (com.ikokoon.serenity.model.Project)dataBase.find(com.ikokoon.serenity.model.Project.class, Toolkit.hash((String)com.ikokoon.serenity.model.Project.class.getName()));
        this.abstractBuild = this.getLastBuild(this.abstractBuild);
        AbstractProject object = this.abstractBuild.getProject();
        if (object instanceof Project) {
            Project hudsonProject = (Project)object;
            String projectName = hudsonProject.getName();
            project.setName(projectName);
        }
        String model = this.getModel("ProjectSmall", (Composite)project);
        return model;
    }

    private AbstractBuild<?, ?> getLastBuild(AbstractBuild<?, ?> abstractBuild) {
        if (abstractBuild.getNextBuild() == null) {
            return abstractBuild;
        }
        return this.getLastBuild((AbstractBuild)abstractBuild.getNextBuild());
    }

    public String getSource() {
        this.logger.debug((Object)"getSource");
        return this.getSource(this.composite);
    }

    public String getFile(String name) {
        return Toolkit.getContents((InputStream)this.getClass().getResourceAsStream(name)).toString();
    }

    private String getSource(Composite<?, ?> composite) {
        this.logger.debug((Object)"getSource");
        if (composite instanceof com.ikokoon.serenity.model.Class) {
            String className = ((com.ikokoon.serenity.model.Class)composite).getName();
            String sourceFilePath = this.abstractBuild.getRootDir().getAbsolutePath() + File.separator + "./serenity/source" + File.separator + className + ".html";
            this.logger.debug((Object)("Looking for source : " + sourceFilePath));
            File sourceFile = new File(sourceFilePath);
            if (sourceFile.exists()) {
                String source = Toolkit.getContents((File)sourceFile).toString();
                return source;
            }
        }
        return "";
    }

    public String getModel(String modelName, Composite<?, ?> composite) {
        this.logger.debug((Object)"getModel");
        if (composite == null) {
            return "";
        }
        LinkedList composites = new LinkedList();
        composites.addFirst(composite);
        LinkedList<Integer> buildNumbers = new LinkedList<Integer>();
        buildNumbers.addFirst(this.abstractBuild.number);
        composites = this.getPreviousComposites(composite.getClass(), this.abstractBuild, composites, buildNumbers, composite.getId(), 1);
        HighchartsModeller modeller = new HighchartsModeller(modelName, buildNumbers.toArray(new Integer[buildNumbers.size()]));
        modeller.visit(composite.getClass(), composites.toArray(new Composite[composites.size()]));
        String model = modeller.getModel();
        return model;
    }

    LinkedList<Composite<?, ?>> getPreviousComposites(Class<Composite<?, ?>> klass, AbstractBuild<?, ?> abstractBuild, LinkedList<Composite<?, ?>> composites, LinkedList<Integer> buildNumbers, Long id, int history) {
        if (history >= 8) {
            return composites;
        }
        this.logger.debug((Object)("Abstract build : " + abstractBuild));
        AbstractBuild previousBuild = (AbstractBuild)abstractBuild.getPreviousBuild();
        if (previousBuild == null) {
            return composites;
        }
        IDataBase dataBase = this.getDataBase(previousBuild);
        if (dataBase == null) {
            return composites;
        }
        Composite composite = dataBase.find(klass, id);
        this.logger.debug((Object)("Looking for composite : " + id + ", " + composite));
        this.closeDataBase(dataBase);
        if (composite == null) {
            return composites;
        }
        composites.addFirst(composite);
        buildNumbers.addFirst(previousBuild.number);
        return this.getPreviousComposites(composite.getClass(), previousBuild, composites, buildNumbers, id, ++history);
    }

    protected void printParameters(StaplerRequest req) {
        Enumeration parameterNames = req.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            this.logger.debug((Object)("Parameter : " + parameterName + ", value : " + req.getParameter(parameterName)));
        }
    }

    private IDataBase getDataBase(AbstractBuild<?, ?> abstractBuild) {
        String dataBaseFile = abstractBuild.getRootDir().getAbsolutePath() + File.separator + "./serenity/serenity.odb";
        return IDataBase.DataBaseManager.getDataBase(DataBaseOdb.class, (String)dataBaseFile, (boolean)false, null);
    }

    private void closeDataBase(IDataBase dataBase) {
        try {
            if (dataBase != null) {
                dataBase.close();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception closing database : " + dataBase), (Throwable)e);
        }
    }
}

