/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.hudson.modeller;

import com.ikokoon.serenity.hudson.modeller.HighchartsModeller;
import com.ikokoon.serenity.hudson.modeller.IModeller;
import com.ikokoon.serenity.model.Class;
import com.ikokoon.serenity.model.Composite;
import com.ikokoon.serenity.model.Package;
import com.ikokoon.serenity.model.Project;
import com.ikokoon.toolkit.Toolkit;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighchartsModeller
implements IModeller {
    private Logger logger = Logger.getLogger(this.getClass());
    private String model;
    private String modelName;
    private Integer[] buildNumbers;
    private Map<String, IConstructor> constructors = new HashMap();

    public HighchartsModeller(String modelName, Integer ... buildNumbers) {
        this.modelName = modelName;
        this.buildNumbers = buildNumbers;
        this.addConstructors();
    }

    public String getModel() {
        return this.model;
    }

    public void visit(java.lang.Class<?> klass, Composite<?, ?> ... composites) {
        InputStream inputStream = null;
        inputStream = this.modelName != null ? this.getClass().getResourceAsStream(this.modelName) : this.getClass().getResourceAsStream(klass.getSimpleName());
        this.model = Toolkit.getContents((InputStream)inputStream).toString();
        String compositeName = this.getName(composites);
        this.model = Toolkit.replaceAll((String)this.model, (String)"compositeName", (String)compositeName);
        for (String dataName : this.constructors.keySet()) {
            String data = this.getData((IConstructor)this.constructors.get(dataName), composites);
            this.logger.debug((Object)("Data : " + data));
            this.model = Toolkit.replaceAll((String)this.model, (String)dataName, (String)data);
        }
    }

    private String getName(Composite<?, ?> ... composites) {
        int i$ = 0;
        Composite<?, ?>[] arr$ = composites;
        int len$ = arr$.length;
        if (i$ < len$) {
            Composite<?, ?> composite = arr$[i$];
            if (composite instanceof Project) {
                return ((Project)composite).getName();
            }
            if (composite instanceof Package) {
                return ((Package)composite).getName();
            }
            if (composite instanceof Class) {
                return ((Class)composite).getName();
            }
            return "What am I";
        }
        return "";
    }

    private String getData(IConstructor constructor, Composite<?, ?> ... composites) {
        StringBuilder builder = new StringBuilder("[0.0,");
        for (int i = 0; i < composites.length; ++i) {
            Composite<?, ?> composite = composites[i];
            constructor.construct(builder, composite);
            if (i + 1 >= composites.length) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    private void addConstructors() {
        this.constructors.put("coverageData", new /* Unavailable Anonymous Inner Class!! */);
        this.constructors.put("complexityData", new /* Unavailable Anonymous Inner Class!! */);
        this.constructors.put("stabilityData", new /* Unavailable Anonymous Inner Class!! */);
        this.constructors.put("abstractnessData", new /* Unavailable Anonymous Inner Class!! */);
        this.constructors.put("distanceData", new /* Unavailable Anonymous Inner Class!! */);
        this.constructors.put("categoryData", new /* Unavailable Anonymous Inner Class!! */);
        this.constructors.put("interfacesData", new /* Unavailable Anonymous Inner Class!! */);
        this.constructors.put("implementationsData", new /* Unavailable Anonymous Inner Class!! */);
        this.constructors.put("linesData", new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Integer[] access$000(HighchartsModeller x0) {
        return x0.buildNumbers;
    }
}

