/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.hudson.modeller;

import com.ikokoon.serenity.hudson.modeller.IModeller;
import com.ikokoon.serenity.model.Composite;
import com.ikokoon.serenity.model.Model;
import com.ikokoon.toolkit.Toolkit;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetChartModeller
implements IModeller {
    private final int PRECISION = 2;
    private String model;
    private Set<String> fields = new TreeSet();

    public JetChartModeller() {
        this.fields.add("coverage");
        this.fields.add("complexity");
        this.fields.add("abstractness");
        this.fields.add("stability");
        this.fields.add("distance");
    }

    public String getModel() {
        return this.model;
    }

    public void visit(Class<?> klass, Composite<?, ?> ... composites) {
        String name = null;
        ArrayList<String> legend = new ArrayList<String>();
        ArrayList<ArrayList> metrics = new ArrayList<ArrayList>();
        Field[] fields = klass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!this.fields.contains(field.getName())) continue;
            String fieldName = field.getName();
            String firstLetter = fieldName.substring(0, 1);
            String firstLetterCapital = firstLetter.toUpperCase();
            legend.add(fieldName.replaceFirst(firstLetter, firstLetterCapital));
        }
        for (Composite<?, ?> composite : composites) {
            name = (String)Toolkit.getValue(klass, composite, (String)"name");
            int index = 0;
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!this.fields.contains(field.getName())) continue;
                String fieldName = field.getName();
                double value = 0.0;
                if (composite != null) {
                    value = (Double)Toolkit.getValue(Double.class, composite, (String)fieldName);
                }
                if (fieldName.equals("abstractness") || fieldName.equals("stability") || fieldName.equals("distance")) {
                    value *= 100.0;
                }
                value = Toolkit.format((double)value, (int)2);
                ArrayList metric = null;
                if (metrics.size() > index) {
                    metric = (ArrayList)metrics.get(index);
                } else {
                    metric = new ArrayList();
                    metrics.add(metric);
                }
                metric.add(value);
                ++index;
            }
        }
        Model model = new Model(name, legend, metrics);
        this.model = Toolkit.serializeToBase64((Object)model);
    }
}

