/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.hudson.source;

import com.ikokoon.serenity.hudson.source.CoverageSourceCode;
import com.ikokoon.serenity.hudson.source.ISourceCode;
import com.ikokoon.serenity.hudson.source.JavaSource2HTMLConverterExt;
import com.ikokoon.serenity.model.Class;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.JavaSourceConversionOptions;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageSourceCode
implements ISourceCode {
    private Logger logger = Logger.getLogger(CoverageSourceCode.class);
    private Class<?, ?> klass;
    private String source;
    private JavaSourceParser javaSourceParser;
    private JavaSourceConversionOptions options = JavaSourceConversionOptions.getRawDefault();

    public CoverageSourceCode(Class<?, ?> klass, String source) {
        this.options.setAddLineAnchors(true);
        this.options.setShowLineNumbers(true);
        this.klass = klass;
        this.source = source;
        try {
            this.javaSourceParser = new JavaSourceParserExt(this);
        }
        catch (Exception e) {
            this.logger.info((Object)"Exception initialising the Java source parser", (Throwable)e);
        }
    }

    public String getSource() {
        if (this.klass != null && this.source != null) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.source.getBytes());
                JavaSource javaSource = this.javaSourceParser.parse((Reader)new InputStreamReader(inputStream));
                JavaSource2HTMLConverterExt converter = new JavaSource2HTMLConverterExt(this.klass);
                StringWriter writer = new StringWriter();
                converter.convert(javaSource, this.options, (Writer)writer);
                String html = writer.toString();
                return html;
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception generating the HTML for the class source : " + this.klass), (Throwable)e);
            }
        }
        return "No source";
    }
}

