/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.hudson.source;

import com.ikokoon.serenity.model.Class;
import com.ikokoon.serenity.model.Line;
import com.ikokoon.serenity.model.Method;
import de.java2html.Version;
import de.java2html.converter.JavaSource2HTMLConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceIterator;
import de.java2html.javasource.JavaSourceRun;
import de.java2html.javasource.JavaSourceType;
import de.java2html.options.HorizontalAlignment;
import de.java2html.options.IHorizontalAlignmentVisitor;
import de.java2html.options.JavaSourceConversionOptions;
import de.java2html.options.JavaSourceStyleEntry;
import de.java2html.options.JavaSourceStyleTable;
import de.java2html.util.HtmlUtilities;
import de.java2html.util.StringHolder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSource2HTMLConverterExt
extends JavaSource2HTMLConverter {
    public boolean java2HtmlHomepageLinkEnabled = false;
    private final String HTML_BLOCK_HEADER = "\n\n<!-- ======================================================== -->\n<!-- = Java Sourcecode to HTML automatically converted code = -->\n<!-- =   " + Version.getJava2HtmlConverterTitle() + " " + Version.getBuildDate() + " by Markus Gebhard  markus@jave.de   = -->\n" + "<!-- =     Further information: http://www.java2html.de     = -->\n" + "<div align=\"{0}\" class=\"java\">\n" + "<table border=\"{1}\" cellpadding=\"3\" " + "cellspacing=\"0\" bgcolor=\"{2}\">\n";
    private Class<?, ?> klass;
    private String STYLE = "style=\"background-color: #C7D6D7;\"";
    private int lineCifferCount;

    public JavaSource2HTMLConverterExt(Class<?, ?> klass) {
        this.klass = klass;
    }

    public void convert(JavaSource source, JavaSourceConversionOptions options, BufferedWriter writer) throws IOException {
        if (source == null) {
            throw new IllegalStateException("Trying to write out converted code without having source set.");
        }
        String alignValue = this.getHtmlAlignValue(options.getHorizontalAlignment());
        String bgcolorValue = options.getStyleTable().get(JavaSourceType.BACKGROUND).getHtmlColor();
        String borderValue = options.isShowTableBorder() ? "2" : "0";
        writer.write(MessageFormat.format(this.HTML_BLOCK_HEADER, alignValue, borderValue, bgcolorValue));
        if (options.isShowFileName() && source.getFileName() != null) {
            this.writeFileName(source, writer);
        }
        writer.write("   <tr>");
        writer.newLine();
        this.writeSourceCode(source, options, writer);
        writer.write("   </tr>");
        writer.newLine();
        if (options.isShowJava2HtmlLink() || this.java2HtmlHomepageLinkEnabled) {
            writer.write("  <!-- start Java2Html link -->\n   <tr>\n    <td align=\"right\">\n<small>\n<a href=\"http://www.java2html.de\" target=\"_blank\">Java2html</a>\n</small>\n    </td>\n   </tr>\n  <!-- end Java2Html link -->\n");
        }
        writer.write("</table>\n</div>\n<!-- =       END of automatically generated HTML code       = -->\n<!-- ======================================================== -->\n\n");
    }

    private String getHtmlAlignValue(HorizontalAlignment alignment) {
        StringHolder stringHolder = new StringHolder();
        alignment.accept((IHorizontalAlignmentVisitor)new /* Unavailable Anonymous Inner Class!! */);
        return stringHolder.getValue();
    }

    private void writeFileName(JavaSource source, BufferedWriter writer) throws IOException {
        writer.write("  <!-- start headline -->\n   <tr>\n    <td colspan=\"2\">\n     <center><font size=\"+2\">\n      <code><b>\n");
        writer.write(source.getFileName());
        writer.newLine();
        writer.write("      </b></code>\n     </font></center>\n    </td>\n   </tr>\n  <!-- end headline -->\n");
    }

    private void writeSourceCode(JavaSource source, JavaSourceConversionOptions options, BufferedWriter writer) throws IOException {
        writer.write("  <!-- start source code -->\n   <td nowrap=\"nowrap\" valign=\"top\" align=\"left\">\n    <code>\n");
        this.lineCifferCount = String.valueOf(source.getLineCount()).length();
        JavaSourceIterator iterator = source.getIterator();
        int lineNumber = 1;
        while (iterator.hasNext()) {
            JavaSourceRun run = iterator.getNext();
            if (run.isAtStartOfLine()) {
                if (options.isAddLineAnchors()) {
                    this.writeLineAnchorStart(options, writer, lineNumber);
                }
                if (options.isShowLineNumbers()) {
                    this.writeLineNumber(options, writer, lineNumber);
                }
                if (options.isAddLineAnchors()) {
                    this.writeLineAnchorEnd(writer);
                }
                ++lineNumber;
            }
            this.toHTML(options.getStyleTable(), run, writer, lineNumber);
            if (!run.isAtEndOfLine() || !iterator.hasNext()) continue;
            writer.write("<br />");
            writer.newLine();
        }
        writer.write("</code>\n    \n   </td>\n  <!-- end source code -->\n");
    }

    private void writeLineAnchorEnd(BufferedWriter writer) throws IOException {
        writer.write("</a>");
    }

    private void writeLineAnchorStart(JavaSourceConversionOptions options, BufferedWriter writer, int lineNumber) throws IOException {
        writer.write("<a name=\"");
        writer.write(options.getLineAnchorPrefix() + lineNumber);
        writer.write("\">");
    }

    private void writeLineNumber(JavaSourceConversionOptions options, BufferedWriter writer, int lineNo) throws IOException {
        JavaSourceStyleEntry styleEntry = options.getStyleTable().get(JavaSourceType.LINE_NUMBERS);
        this.writeStyleStart(writer, styleEntry, -1);
        String lineNumber = String.valueOf(lineNo);
        for (int cifferCount = this.lineCifferCount - lineNumber.length(); cifferCount > 0; --cifferCount) {
            writer.write(48);
        }
        writer.write(lineNumber);
        this.writeStyleEnd(writer, styleEntry);
        writer.write("&nbsp;");
    }

    private void toHTML(JavaSourceStyleTable styleTable, JavaSourceRun run, BufferedWriter writer, int lineNumber) throws IOException {
        JavaSourceStyleEntry style = styleTable.get(run.getType());
        this.writeStyleStart(writer, style, lineNumber);
        String t = HtmlUtilities.encode((String)run.getCode(), (String)"\n ");
        for (int i = 0; i < t.length(); ++i) {
            char ch = t.charAt(i);
            if (ch == ' ') {
                writer.write("&nbsp;");
                continue;
            }
            writer.write(ch);
        }
        this.writeStyleEnd(writer, style);
    }

    private void writeStyleStart(BufferedWriter writer, JavaSourceStyleEntry style, int lineNumber) throws IOException {
        if (this.getCovered(this.klass, (double)(lineNumber - 1))) {
            writer.write("<font color=\"" + style.getHtmlColor() + "\" " + this.STYLE + ">");
        } else {
            writer.write("<font color=\"" + style.getHtmlColor() + "\">");
        }
        if (style.isBold()) {
            writer.write("<b>");
        }
        if (style.isItalic()) {
            writer.write("<i>");
        }
    }

    private void writeStyleEnd(BufferedWriter writer, JavaSourceStyleEntry style) throws IOException {
        if (style.isItalic()) {
            writer.write("</i>");
        }
        if (style.isBold()) {
            writer.write("</b>");
        }
        writer.write("</font>");
    }

    private boolean getCovered(Class<?, ?> klass, double lineNumber) {
        for (Method method : klass.getChildren()) {
            for (Line line : method.getChildren()) {
                boolean lineCovered;
                if (line.getNumber() != lineNumber) continue;
                boolean bl = lineCovered = line.getCounter() > 0.0;
                if (lineCovered) {
                    // empty if block
                }
                return lineCovered;
            }
        }
        for (Class innerKlass : klass.getInnerClasses()) {
            boolean covered = this.getCovered(innerKlass, lineNumber);
            if (!covered) continue;
            return true;
        }
        return false;
    }
}

