/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.instrumentation.complexity;

import com.ikokoon.serenity.Collector;
import com.ikokoon.serenity.instrumentation.coverage.CoverageMethodAdapter;
import com.ikokoon.toolkit.Toolkit;
import org.apache.log4j.Logger;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;

public class ComplexityMethodAdapter
extends MethodAdapter {
    private Logger logger = Logger.getLogger(CoverageMethodAdapter.class);
    private String className;
    private String methodName;
    private String methodDescription;
    private int complexityCounter = 1;

    public ComplexityMethodAdapter(MethodVisitor methodVisitor, Integer access, String className, String methodName, String methodDescription) {
        super(methodVisitor);
        this.className = Toolkit.slashToDot((String)className);
        this.methodName = methodName;
        this.methodDescription = methodDescription;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Class name : " + className + ", name : " + methodName + ", desc : " + methodDescription));
        }
    }

    public void visitLineNumber(int lineNumber, Label label) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitLineNumber : " + lineNumber + ", " + label + ", " + label.getOffset() + ", " + this.className + ", " + this.methodName));
        }
        this.mv.visitLineNumber(lineNumber, label);
    }

    public void visitJumpInsn(int opcode, Label paramLabel) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitJumpInsn:" + opcode));
        }
        ++this.complexityCounter;
        this.mv.visitJumpInsn(opcode, paramLabel);
    }

    public void visitEnd() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("visitEnd:" + this.className + ", " + this.methodName + ", " + this.methodDescription));
        }
        Collector.collectComplexity((String)this.className, (String)this.methodName, (String)this.methodDescription, (double)this.complexityCounter);
        this.mv.visitEnd();
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.logger.debug((Object)("visitTryCatchBlock : " + this.className + ", " + this.methodName));
        ++this.complexityCounter;
        this.mv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.logger.debug((Object)("visitlookupSwitchInst : " + this.className + ", " + this.methodName));
        ++this.complexityCounter;
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.logger.debug((Object)("visitTableSwitchInst : " + this.className + ", " + this.methodName));
        ++this.complexityCounter;
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitInsn(int opcode) {
        this.logger.debug((Object)("visitInst : " + this.className + ", " + this.methodName));
        this.mv.visitInsn(opcode);
    }
}

