/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.instrumentation.coverage;

import com.ikokoon.serenity.Collector;
import com.ikokoon.toolkit.Toolkit;
import org.apache.log4j.Logger;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class CoverageMethodAdapter
extends MethodAdapter {
    private Logger logger = Logger.getLogger(CoverageMethodAdapter.class);
    private Type stringType = Type.getType(String.class);
    private Type intType = Type.getType(Integer.TYPE);
    private Type[] types = new Type[]{this.stringType, this.stringType, this.stringType, this.intType};
    private String collectorClassName = Type.getInternalName(Collector.class);
    private String collectorMethodName = "collectCoverage";
    private String collectorMethodDescription = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])this.types);
    private String className;
    private String methodName;
    private String methodDescription;

    public CoverageMethodAdapter(MethodVisitor methodVisitor, Integer access, String className, String methodName, String methodDescription) {
        super(methodVisitor);
        this.className = Toolkit.slashToDot((String)className);
        this.methodName = methodName;
        this.methodDescription = methodDescription;
        this.logger.debug((Object)("Class name : " + className + ", name : " + methodName + ", desc : " + methodDescription));
    }

    public void visitLineNumber(int lineNumber, Label label) {
        this.logger.debug((Object)("visitLineNumber : " + lineNumber + ", " + label + ", " + label.getOffset() + ", " + this.className + ", " + this.methodName));
        this.mv.visitLdcInsn((Object)this.className);
        this.mv.visitLdcInsn((Object)this.methodName);
        this.mv.visitLdcInsn((Object)this.methodDescription);
        this.mv.visitLdcInsn((Object)lineNumber);
        this.mv.visitMethodInsn(184, this.collectorClassName, this.collectorMethodName, this.collectorMethodDescription);
        this.mv.visitLineNumber(lineNumber, label);
    }
}

