/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.instrumentation.dependency;

import com.ikokoon.serenity.instrumentation.VisitorFactory;
import com.ikokoon.toolkit.Toolkit;
import org.apache.log4j.Logger;
import org.objectweb.asm.AnnotationVisitor;

public class DependencyAnnotationAdapter
implements AnnotationVisitor {
    private Logger logger = Logger.getLogger(this.getClass());
    private AnnotationVisitor annotationVisitor;
    private String className;

    public DependencyAnnotationAdapter(AnnotationVisitor annotationVisitor, String className, String description) {
        this.logger.debug((Object)("Class name : " + className + ", " + description));
        this.className = Toolkit.slashToDot((String)className);
        this.annotationVisitor = annotationVisitor;
        VisitorFactory.getSignatureVisitor((String)className, (String)description);
    }

    public void visit(String name, Object value) {
        this.logger.debug((Object)("visit : " + this.className + ", " + name + ", " + value));
        if (name != null && value != null) {
            try {
                VisitorFactory.getSignatureVisitor((String)this.className, (String)value.toString());
            }
            catch (StringIndexOutOfBoundsException e) {
                this.logger.debug((Object)("String out of bounds for : " + this.className + ", " + name + ", " + value));
            }
        }
        if (name != null) {
            this.annotationVisitor.visit(name, value);
        }
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.logger.debug((Object)("visitAnnotation : " + this.className + ", " + name + ", " + desc));
        AnnotationVisitor visitor = this.annotationVisitor.visitAnnotation(name, desc);
        AnnotationVisitor adapter = VisitorFactory.getAnnotationVisitor((AnnotationVisitor)visitor, (String)name, (String)desc);
        return adapter;
    }

    public AnnotationVisitor visitArray(String name) {
        this.logger.debug((Object)("visitArray : " + this.className + ", " + name));
        return this.annotationVisitor.visitArray(name);
    }

    public void visitEnd() {
        this.logger.debug((Object)("visitEnd : " + this.className));
        this.annotationVisitor.visitEnd();
    }

    public void visitEnum(String name, String desc, String value) {
        this.logger.debug((Object)("visitEnum : " + this.className + ", " + name + ", " + desc + ", " + value));
        VisitorFactory.getSignatureVisitor((String)this.className, (String)desc);
        if (name != null) {
            this.annotationVisitor.visitEnum(name, desc, value);
        }
    }
}

