/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.instrumentation.dependency;

import com.ikokoon.serenity.Collector;
import com.ikokoon.serenity.instrumentation.VisitorFactory;
import com.ikokoon.toolkit.Toolkit;
import org.apache.log4j.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;

public class DependencyFieldAdapter
implements FieldVisitor {
    private Logger logger = Logger.getLogger(this.getClass());
    private FieldVisitor visitor;
    private String className;

    public DependencyFieldAdapter(FieldVisitor visitor, String className, String description, String signature) {
        this.visitor = visitor;
        this.className = Toolkit.slashToDot((String)className);
        this.logger.debug((Object)("Class name : " + this.className + ", " + description + ", " + signature));
        VisitorFactory.getSignatureVisitor((String)this.className, (String)description);
        if (signature != null) {
            VisitorFactory.getSignatureVisitor((String)this.className, (String)signature);
            String targetClassName = Type.getType((String)description).getClassName();
            Collector.collectEfferentAndAfferent((String)this.className, (String[])new String[]{targetClassName});
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.logger.debug((Object)("visitAnnotation : " + desc + ", " + visible));
        AnnotationVisitor annotationVisitor = this.visitor.visitAnnotation(desc, visible);
        AnnotationVisitor adapter = VisitorFactory.getAnnotationVisitor((AnnotationVisitor)annotationVisitor, (String)this.className, (String)desc);
        return adapter;
    }

    public void visitAttribute(Attribute attr) {
        this.visitor.visitAttribute(attr);
    }

    public void visitEnd() {
        this.visitor.visitEnd();
    }
}

