/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.instrumentation.dependency;

import com.ikokoon.serenity.Collector;
import com.ikokoon.toolkit.Toolkit;
import org.apache.log4j.Logger;
import org.objectweb.asm.signature.SignatureVisitor;

public class DependencySignatureAdapter
implements SignatureVisitor {
    private Logger logger = Logger.getLogger(this.getClass());
    private String className;

    public DependencySignatureAdapter(String className) {
        this.className = Toolkit.slashToDot((String)className);
        this.logger.debug((Object)("Class name : " + className));
    }

    public void visitClassType(String name) {
        this.logger.debug((Object)("visitClassType : " + name));
        String normedName = Toolkit.slashToDot((String)name);
        Collector.collectEfferentAndAfferent((String)this.className, (String[])new String[]{normedName});
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        this.logger.debug((Object)("visitTypeArgument : " + wildcard));
        return this;
    }

    public void visitTypeVariable(String name) {
        this.logger.debug((Object)("visitTypeVariable : " + name));
    }

    public void visitBaseType(char descriptor) {
        this.logger.debug((Object)("visitBaseType : " + descriptor));
    }

    public void visitFormalTypeParameter(String name) {
        this.logger.debug((Object)("visitFormalTypeParameter : " + name));
    }

    public void visitInnerClassType(String name) {
        this.logger.debug((Object)("visitInnerClassType : " + name));
    }

    public SignatureVisitor visitArrayType() {
        return this;
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public void visitEnd() {
        this.logger.debug((Object)"visitEnd : ");
    }

    public SignatureVisitor visitExceptionType() {
        this.logger.debug((Object)"visitExceptionType : ");
        return this;
    }

    public SignatureVisitor visitInterface() {
        this.logger.debug((Object)"visitInterface : ");
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.logger.debug((Object)"visitInterfaceBound : ");
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.logger.debug((Object)"visitParameterType : ");
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.logger.debug((Object)"visitReturnType : ");
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.logger.debug((Object)"visitSuperClass : ");
        return this;
    }

    public void visitTypeArgument() {
        this.logger.debug((Object)"visitArgumentType : ");
    }
}

