/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.persistence;

import com.ikokoon.serenity.model.Composite;
import com.ikokoon.serenity.persistence.DataBase;
import com.ikokoon.toolkit.Toolkit;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBaseJpa
extends DataBase {
    private Logger logger = Logger.getLogger(this.getClass());
    @PersistenceContext(type=PersistenceContextType.TRANSACTION, unitName="SerenityPersistenceUnit")
    private EntityManager entityManager;
    private boolean closed = true;

    DataBaseJpa() {
        this.getEntityManager();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <E extends Composite<?, ?>> E find(Class<E> klass, Long id) {
        boolean commit = this.begin();
        try {
            Composite e = (Composite)this.entityManager.find(klass, (Object)id);
            this.logger.info((Object)("find(klass, id) : " + e));
            Composite composite = e;
            return (E)composite;
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception finding : " + klass + ", " + id), (Throwable)e);
        }
        finally {
            this.commit(commit);
        }
        return null;
    }

    public synchronized <E extends Composite<?, ?>> E find(Class<E> klass, List<Object> parameters) {
        Long id = Toolkit.hash((Object[])parameters.toArray());
        return (E)this.find(klass, id);
    }

    public synchronized <E extends Composite<?, ?>> List<E> find(Class<E> klass) {
        return this.entityManager.createQuery("from " + klass.getSimpleName()).getResultList();
    }

    public <E extends Composite<?, ?>> List<E> find(Class<E> klass, Map<String, Object> parameters) {
        throw new RuntimeException("Not implempented.");
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized <E extends Composite<?, ?>> E persist(E composite) {
        boolean commit = this.begin();
        this.entityManager.persist(composite);
        this.commit(commit);
        return composite;
    }

    public synchronized <E extends Composite<?, ?>> E remove(Class<E> klass, Long id) {
        Composite composite = this.find(klass, id);
        if (composite != null) {
            boolean commit = this.begin();
            this.entityManager.remove((Object)composite);
            this.commit(commit);
        }
        return (E)composite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        this.logger.info((Object)("Closing the JPA database : " + this.entityManager.isOpen()));
        if (this.entityManager.isOpen()) {
            boolean commit = this.begin();
            try {
                this.entityManager.flush();
            }
            finally {
                this.commit(commit);
            }
            this.entityManager.close();
            this.closed = true;
        }
    }

    private synchronized boolean begin() {
        EntityTransaction transaction = this.entityManager.getTransaction();
        if (!transaction.isActive()) {
            this.entityManager.getTransaction().begin();
            return true;
        }
        return false;
    }

    private synchronized void commit(boolean commit) {
        EntityTransaction transaction;
        if (commit && (transaction = this.entityManager.getTransaction()).isActive()) {
            if (!transaction.getRollbackOnly()) {
                transaction.commit();
            } else {
                transaction.rollback();
            }
        }
    }

    private synchronized EntityManager getEntityManager() {
        if (this.entityManager == null) {
            try {
                EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"SerenityPersistenceUnit");
                this.entityManager = factory.createEntityManager();
            }
            catch (Exception e) {
                this.logger.error((Object)"Error setting up the entity manager in stand alone.", (Throwable)e);
            }
        }
        return this.entityManager;
    }
}

