/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.serenity.persistence;

import com.ikokoon.serenity.model.Class;
import com.ikokoon.serenity.model.Composite;
import com.ikokoon.serenity.model.Package;
import com.ikokoon.serenity.model.Project;
import com.ikokoon.serenity.persistence.DataBase;
import com.ikokoon.serenity.persistence.DataBaseRam;
import com.ikokoon.serenity.persistence.IDataBase;
import com.ikokoon.serenity.persistence.IDataBaseEvent;
import com.ikokoon.serenity.persistence.IDataBaseListener;
import com.ikokoon.toolkit.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataBaseRam
extends DataBase {
    private Logger logger = Logger.getLogger(this.getClass());
    private IDataBase dataBase;
    private IDataBaseListener dataBaseListener;
    private boolean closed = true;
    private volatile transient List<Composite<?, ?>> index = new ArrayList();

    DataBaseRam(IDataBase dataBase, IDataBaseListener dataBaseListener) {
        this.logger.info((Object)("Opening RAM database with " + dataBase + " underneath."));
        this.dataBase = dataBase;
        this.dataBaseListener = dataBaseListener;
        this.index.clear();
        this.closed = false;
    }

    public final synchronized <E extends Composite<?, ?>> E persist(E composite) {
        this.setIds(composite);
        return composite;
    }

    public final synchronized <E extends Composite<?, ?>> E find(java.lang.Class<E> klass, Long id) {
        return (E)this.search(this.index, id.longValue());
    }

    public final synchronized <E extends Composite<?, ?>> E find(java.lang.Class<E> klass, List<Object> parameters) {
        Long id = Toolkit.hash((Object[])parameters.toArray());
        return (E)this.search(this.index, id.longValue());
    }

    public final synchronized <E extends Composite<?, ?>> List<E> find(java.lang.Class<E> klass) {
        ArrayList<Composite> list = new ArrayList<Composite>();
        for (Composite composite : this.index) {
            if (!klass.isInstance(composite)) continue;
            list.add(composite);
        }
        return list;
    }

    public final synchronized <E extends Composite<?, ?>> E remove(java.lang.Class<E> klass, Long id) {
        Composite composite = this.find(klass, id);
        if (composite != null) {
            List children;
            Composite parent = composite.getParent();
            if (parent != null && (children = parent.getChildren()) != null) {
                children.remove(composite);
            }
            composite.setParent(null);
            if (!this.index.remove(composite)) {
                this.logger.warn((Object)("Didn't remove composite with id : " + id + ", because it wasn't in the index."));
            }
        }
        return (E)composite;
    }

    public final synchronized boolean isClosed() {
        if (this.dataBase != null && !this.closed && this.dataBase.isClosed()) {
            this.closed = true;
        }
        return this.closed;
    }

    public final synchronized void close() {
        if (this.closed) {
            this.logger.info((Object)"User tried to close the database again");
            return;
        }
        this.logger.info((Object)"Comitting and closing the database");
        try {
            this.logger.info((Object)("Persisting index : " + this.dataBase));
            if (this.dataBase != null) {
                for (Composite composite : this.index) {
                    if (!Package.class.isInstance(composite) && !Project.class.isInstance(composite)) continue;
                    this.logger.debug((Object)("Persisting : " + composite));
                    this.dataBase.persist(composite);
                }
                this.dataBase.close();
            } else {
                this.logger.warn((Object)("Persistence database was null : " + this));
            }
            this.index.clear();
            DataBaseRam dataBase = this;
            1 dataBaseEvent = new /* Unavailable Anonymous Inner Class!! */;
            this.dataBaseListener.fireDataBaseEvent((IDataBaseEvent)dataBaseEvent);
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception comitting and closing the database", (Throwable)e);
        }
        this.closed = true;
    }

    final synchronized <T> void setIds(Composite<?, ?> composite) {
        String name;
        if (composite == null) {
            return;
        }
        super.setId(composite);
        this.insert(this.index, composite);
        this.logger.debug((Object)("Persisted object : " + composite));
        if (composite instanceof Class && (name = ((Class)composite).getName()).indexOf(47) > -1) {
            this.logger.warn((Object)("Invalid class name : " + name));
            Thread.dumpStack();
        }
        List children = composite.getChildren();
        for (Composite child : children) {
            this.setIds(child);
        }
    }

    final <E extends Composite<?, ?>> E search(List<Composite<?, ?>> index, long id) {
        int low = 0;
        int high = index.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Composite<?, ?> composite = index.get(mid);
            long midVal = composite.getId();
            if (midVal < id) {
                low = mid + 1;
                continue;
            }
            if (midVal > id) {
                high = mid - 1;
                continue;
            }
            return (E)composite;
        }
        return null;
    }

    final void insert(List<Composite<?, ?>> index, Composite<?, ?> toInsert) {
        boolean inserted = false;
        if (index.size() == 0) {
            index.add(toInsert);
            inserted = true;
        } else {
            long key = toInsert.getId();
            int low = 0;
            int high = index.size();
            while (low <= high) {
                int mid = low + high >>> 1;
                if (mid >= index.size()) {
                    index.add(mid, toInsert);
                    inserted = true;
                    break;
                }
                Composite<?, ?> composite = index.get(mid);
                long midVal = composite.getId();
                if (midVal < key) {
                    Composite<?, ?> nextComposite;
                    long nextVal;
                    int next = mid + 1;
                    if (index.size() > next && (nextVal = (nextComposite = index.get(next)).getId().longValue()) > key) {
                        index.add(next, toInsert);
                        inserted = true;
                        break;
                    }
                    low = mid + 1;
                    continue;
                }
                if (midVal <= key) break;
                int previous = mid - 1;
                if (previous >= 0) {
                    Composite<?, ?> previousComposite = index.get(previous);
                    long previousVal = previousComposite.getId();
                    if (previousVal < key) {
                        index.add(mid, toInsert);
                        inserted = true;
                        break;
                    }
                } else {
                    index.add(0, toInsert);
                    inserted = true;
                    break;
                }
                high = mid - 1;
            }
        }
        this.logger.debug((Object)("Inserted : " + toInsert + " - " + inserted));
    }

    public <E extends Composite<?, ?>> List<E> find(java.lang.Class<E> klass, Map<String, Object> parameters) {
        throw new RuntimeException("Not implempented.");
    }
}

