/*
 * Decompiled with CFR 0.152.
 */
package com.ikokoon.toolkit;

import com.ikokoon.serenity.model.Unique;
import com.ikokoon.toolkit.Base64;
import com.ikokoon.toolkit.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Toolkit {
    private static Logger logger = Logger.getLogger(Toolkit.class);

    public static final Long hash(String string) {
        long seed = 131L;
        long hash = 0L;
        char[] chars = string.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            hash = hash * seed + (long)chars[i];
        }
        return Math.abs(hash);
    }

    public static final Long hash(Object ... objects) {
        StringBuilder builder = new StringBuilder();
        for (Object object : objects) {
            builder.append(object);
        }
        Long hash = Toolkit.hash((String)builder.toString());
        return hash;
    }

    public static String slashToDot(String name) {
        if (name == null) {
            return name;
        }
        name = name.replace('/', '.');
        name = name.replace('\\', '.');
        return name;
    }

    public static String dotToSlash(String name) {
        if (name == null) {
            return name;
        }
        name = name.replace('.', '/');
        return name;
    }

    public static String classNameToPackageName(String className) {
        Type type = Type.getObjectType((String)className);
        int index = (className = type.getClassName()).lastIndexOf(46);
        if (index > -1) {
            return className.substring(0, index);
        }
        return "";
    }

    public static String stripWhitespace(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = string.toCharArray();
        boolean state = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) {
                if (state) continue;
                state = true;
                buffer.append(' ');
                continue;
            }
            state = false;
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static Field getField(Class<?> klass, String name) {
        Class<?> superClass;
        if (klass == null || name == null) {
            return null;
        }
        Field field = null;
        try {
            field = klass.getDeclaredField(name);
        }
        catch (Throwable t) {
            t.getCause();
        }
        if (field == null && (superClass = klass.getSuperclass()) != null) {
            field = Toolkit.getField(superClass, (String)name);
        }
        return field;
    }

    public static <E> E getValue(Class<E> klass, Object object, String name) {
        if (object == null) {
            return null;
        }
        Field field = Toolkit.getField(object.getClass(), (String)name);
        if (field != null) {
            try {
                field.setAccessible(true);
                return (E)field.get(object);
            }
            catch (Exception e) {
                logger.error((Object)"Exception accessing the field's value", (Throwable)e);
            }
        }
        return null;
    }

    public static void deleteFile(File file, int maxRetryCount, int retryCount) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int j = 0; j < children.length; ++j) {
                File child = children[j];
                Toolkit.deleteFile((File)child, (int)maxRetryCount, (int)0);
            }
        }
        logger.warn((Object)("File : " + file));
        if (file.delete()) {
            logger.warn((Object)("Deleted file : " + file));
        } else if (retryCount >= maxRetryCount) {
            if (file.exists()) {
                logger.warn((Object)("Couldn't delete file : " + file));
            }
        } else {
            logger.warn((Object)("Retrying count : " + retryCount + ", file : " + file));
            Toolkit.deleteFile((File)file, (int)maxRetryCount, (int)(++retryCount));
        }
    }

    public static void deleteFiles(File file, String ... extensions) {
        if (file == null || !file.exists() || !file.canWrite()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int j = 0; j < files.length; ++j) {
                file = files[j];
                Toolkit.deleteFiles((File)file, (String[])extensions);
            }
        }
        if (file.isFile()) {
            String fileName = file.getName();
            for (String extension : extensions) {
                if (!fileName.endsWith(extension)) continue;
                if (file.delete()) {
                    logger.debug((Object)("Deleted file : " + file));
                    continue;
                }
                logger.warn((Object)("Couldn't delete file : " + file));
            }
        }
    }

    public static void findFiles(File file, IFileFilter filter, List<File> list) {
        if (file == null || !file.exists()) {
            return;
        }
        if (filter.matches(file)) {
            list.add(file);
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int j = 0; files != null && j < files.length; ++j) {
                Toolkit.findFiles((File)files[j], (IFileFilter)filter, list);
            }
        }
    }

    public static ByteArrayOutputStream getContents(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"No file by that name.", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("General error accessing the file " + file), (Throwable)e);
        }
        return Toolkit.getContents((InputStream)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream getContents(InputStream inputStream) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (inputStream == null) {
            return bos;
        }
        try {
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) > -1) {
                bos.write(bytes, 0, read);
            }
            logger.debug((Object)("Read bytes : " + bos.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"Exception accessing the file contents.", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                logger.error((Object)("Exception closing input stream " + inputStream), (Throwable)e);
            }
        }
        return bos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File file, byte[] bytes) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(bytes, 0, bytes.length);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("File " + file + " not found"), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"IO exception writing file contents", (Throwable)e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Exception closing the output stream", (Throwable)e);
                }
            }
        }
    }

    public static double format(double d, int precision) {
        String doubleString = Double.toString(d);
        doubleString = Toolkit.format((String)doubleString, (int)precision);
        try {
            d = Double.parseDouble(doubleString);
        }
        catch (Exception e) {
            logger.error((Object)("Exception formatting : " + d + ", " + precision), (Throwable)e);
        }
        return d;
    }

    public static String format(String string, int precision) {
        if (string == null) {
            return string;
        }
        char[] chars = string.trim().toCharArray();
        StringBuilder builder = new StringBuilder();
        boolean decimal = true;
        boolean state = false;
        int decimals = 0;
        block3: for (char c : chars) {
            switch (c) {
                case ',': 
                case '.': {
                    state = decimal;
                    builder.append(c);
                    continue block3;
                }
                default: {
                    if (state == decimal && decimals++ >= precision) continue block3;
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    public static String serializeToBase64(Object object) {
        String base64 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] bytes = byteArrayOutputStream.toByteArray();
            base64 = Base64.encode((byte[])bytes);
            base64 = base64.replaceAll("\n", "");
            base64 = base64.replaceAll("\r", "");
            base64 = base64.replaceAll("\t", "");
        }
        catch (Exception e) {
            logger.error((Object)("Exception serializing the object : " + object), (Throwable)e);
        }
        return base64;
    }

    public static Object deserializeFromBase64(String base64) {
        byte[] bytes = Base64.decode((String)base64);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (Exception e) {
            logger.error((Object)("Exception deserializing the object from the base 64 string : " + base64), (Throwable)e);
            return null;
        }
    }

    public static <T> T[] getUniqueValues(T t) {
        Unique unique = t.getClass().getAnnotation(Unique.class);
        if (unique == null) {
            return new Object[]{t};
        }
        String[] fields = unique.fields();
        ArrayList<Object> values = new ArrayList<Object>();
        for (String field : fields) {
            Object[] uniqueValues;
            Object value = Toolkit.getValue(Object.class, t, (String)field);
            for (Object uniqueValue : uniqueValues = Toolkit.getUniqueValues((Object)value)) {
                values.add(uniqueValue);
            }
        }
        return values.toArray(new Object[values.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) {
        if (!src.exists()) {
            logger.warn((Object)("Source file/directory does not exist : " + src));
            return;
        }
        if (!src.canRead()) {
            logger.warn((Object)("Source file/directory not readable : " + src));
            return;
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                logger.warn((Object)("Could not create the new destination directory : " + dest));
            }
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                File dest1 = new File(dest, list[i]);
                File src1 = new File(src, list[i]);
                Toolkit.copyFile((File)src1, (File)dest1);
            }
        } else {
            FileInputStream fin = null;
            FileOutputStream fout = null;
            byte[] buffer = new byte[4096];
            try {
                int bytesRead;
                fin = new FileInputStream(src);
                fout = new FileOutputStream(dest);
                while ((bytesRead = fin.read(buffer)) >= 0) {
                    fout.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                logger.error((Object)("Exception copying the source " + src + ", to destination : " + dest), (Throwable)e);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)("Exception closing the source input stream : " + fin), (Throwable)e);
                    }
                }
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)("Exception closing the destination output stream : " + fout), (Throwable)e);
                    }
                }
            }
        }
    }

    public static String replaceAll(String aInput, String aOldPattern, String aNewPattern) {
        if (aOldPattern.equals("")) {
            throw new IllegalArgumentException("Old pattern must have content.");
        }
        StringBuffer result = new StringBuffer();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = aInput.indexOf(aOldPattern, startIdx)) >= 0) {
            result.append(aInput.substring(startIdx, idxOld));
            result.append(aNewPattern);
            startIdx = idxOld + aOldPattern.length();
        }
        result.append(aInput.substring(startIdx));
        return result.toString();
    }
}

