/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sfee;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.sfee.SourceForgeProject;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.FullControlOnceLoggedInAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SparseACL;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.Sid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFEEProjectBasedAuthorizationStrategy
extends FullControlOnceLoggedInAuthorizationStrategy {
    public static final SparseACL UNSECURED_PROJECT_ACL = new SparseACL(null);
    public static final Descriptor<AuthorizationStrategy> DESCRIPTOR;

    public ACL getRootACL() {
        return UNSECURED_PROJECT_ACL;
    }

    public GrantedAuthority createAuthority(AbstractProject<?, ?> project) {
        SourceForgeProject p = (SourceForgeProject)project.getProperty(SourceForgeProject.class);
        if (p != null) {
            return new GrantedAuthorityImpl(p.getProjectId());
        }
        return null;
    }

    public ACL getACL(AbstractProject<?, ?> project) {
        GrantedAuthority auth = this.createAuthority(project);
        if (auth != null) {
            SparseACL acl = new SparseACL(this.getRootACL());
            acl.add((Sid)new GrantedAuthoritySid(auth), Permission.FULL_CONTROL, true);
            return acl;
        }
        return UNSECURED_PROJECT_ACL;
    }

    public Descriptor<AuthorizationStrategy> getDescriptor() {
        return DESCRIPTOR;
    }

    static {
        UNSECURED_PROJECT_ACL.add(ACL.ANONYMOUS, Permission.FULL_CONTROL, false);
        UNSECURED_PROJECT_ACL.add(ACL.EVERYONE, Permission.FULL_CONTROL, true);
        DESCRIPTOR = new /* Unavailable Anonymous Inner Class!! */;
    }
}

